/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermParameterBo;
import org.kuali.rice.krms.impl.repository.TermResolverAttributeBo;
import org.kuali.rice.krms.impl.repository.TermResolverBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;
import org.springframework.util.CollectionUtils;

public class TermBoServiceImpl
implements TermBoService {
    private BusinessObjectService businessObjectService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public TermSpecificationDefinition getTermSpecificationById(String id) {
        TermSpecificationDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermSpecificationBo termSpecificationBo = (TermSpecificationBo)this.businessObjectService.findBySinglePrimaryKey(TermSpecificationBo.class, (Object)id);
        if (termSpecificationBo != null) {
            if (termSpecificationBo.getContextIds() != null && termSpecificationBo.getContextIds().isEmpty() && termSpecificationBo.getContexts() != null && !termSpecificationBo.getContexts().isEmpty()) {
                ArrayList<String> contextIds = new ArrayList<String>();
                for (ContextBo context : termSpecificationBo.getContexts()) {
                    contextIds.add(context.getId());
                }
                termSpecificationBo.setContextIds(contextIds);
            }
            result = TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpecificationBo).build();
        }
        return result;
    }

    public TermSpecificationDefinition createTermSpecification(TermSpecificationDefinition termSpec) {
        if (!StringUtils.isBlank((String)termSpec.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermSpecification.id must be null");
        }
        TermSpecificationBo termSpecBo = TermSpecificationBo.from(termSpec);
        termSpecBo = (TermSpecificationBo)this.businessObjectService.save((PersistableBusinessObject)termSpecBo);
        if (!CollectionUtils.isEmpty((Collection)termSpec.getContextIds())) {
            for (String contextId : termSpec.getContextIds()) {
                ContextValidTermBo contextValidTerm = new ContextValidTermBo();
                contextValidTerm.setContextId(contextId);
                contextValidTerm.setTermSpecificationId(termSpecBo.getId());
                this.businessObjectService.save((PersistableBusinessObject)contextValidTerm);
            }
        }
        return TermSpecificationBo.to(termSpecBo);
    }

    public void updateTermSpecification(TermSpecificationDefinition termSpec) throws RiceIllegalArgumentException {
        TermSpecificationDefinition toUpdate;
        if (termSpec == null) {
            throw new IllegalArgumentException("term specification is null");
        }
        String termSpecificationId = termSpec.getId();
        TermSpecificationBo existing = (TermSpecificationBo)this.businessObjectService.findBySinglePrimaryKey(TermSpecificationBo.class, (Object)termSpecificationId);
        if (existing == null) {
            throw new IllegalStateException("the term specification does not exist: " + termSpec);
        }
        if (!existing.getId().equals(termSpec.getId())) {
            TermSpecificationDefinition.Builder builder = TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)termSpec);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = termSpec;
        }
        TermSpecificationBo boToUpdate = TermSpecificationBo.from(toUpdate);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    public void deleteTermSpecification(String id) throws RiceIllegalArgumentException {
        if (id == null) {
            throw new RiceIllegalArgumentException("agendaId is null");
        }
        TermSpecificationBo existing = (TermSpecificationBo)this.businessObjectService.findBySinglePrimaryKey(TermSpecificationBo.class, (Object)id);
        if (existing == null) {
            throw new IllegalStateException("the TermSpecification to delete does not exists: " + id);
        }
        this.businessObjectService.delete((PersistableBusinessObject)existing);
    }

    public TermDefinition createTerm(TermDefinition termDef) {
        if (!StringUtils.isBlank((String)termDef.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermDefinition.id must be null");
        }
        TermBo termBo = TermBo.from(termDef);
        this.businessObjectService.save((PersistableBusinessObject)termBo);
        return TermBo.to(termBo);
    }

    public void updateTerm(TermDefinition term) throws RiceIllegalArgumentException {
        TermDefinition toUpdate;
        if (term == null) {
            throw new IllegalArgumentException("term is null");
        }
        String termId = term.getId();
        TermBo existing = (TermBo)this.businessObjectService.findBySinglePrimaryKey(TermBo.class, (Object)termId);
        if (existing == null) {
            throw new IllegalStateException("the term resolver does not exist: " + term);
        }
        if (!existing.getId().equals(term.getId())) {
            TermDefinition.Builder builder = TermDefinition.Builder.create((TermDefinitionContract)term);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = term;
        }
        TermBo boToUpdate = TermBo.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("termId", toUpdate.getId());
        this.businessObjectService.deleteMatching(TermParameterBo.class, fields);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    public void deleteTerm(String id) throws RiceIllegalArgumentException {
        if (id == null) {
            throw new RiceIllegalArgumentException("termId is null");
        }
        TermBo existing = (TermBo)this.businessObjectService.findBySinglePrimaryKey(TermBo.class, (Object)id);
        if (existing == null) {
            throw new IllegalStateException("the term to delete does not exists: " + id);
        }
        this.businessObjectService.delete((PersistableBusinessObject)existing);
    }

    public TermResolverDefinition createTermResolver(TermResolverDefinition termResolver) {
        if (!StringUtils.isBlank((String)termResolver.getId())) {
            throw new RiceIllegalArgumentException("for creation, TermResolverDefinition.id must be null");
        }
        TermResolverBo termResolverBo = TermResolverBo.from(termResolver);
        termResolverBo = (TermResolverBo)this.businessObjectService.save((PersistableBusinessObject)termResolverBo);
        return TermResolverBo.to(termResolverBo);
    }

    public void updateTermResolver(TermResolverDefinition termResolver) throws RiceIllegalArgumentException {
        TermResolverDefinition toUpdate;
        if (termResolver == null) {
            throw new IllegalArgumentException("term resolver is null");
        }
        String termResolverId = termResolver.getId();
        TermResolverBo existing = (TermResolverBo)this.businessObjectService.findBySinglePrimaryKey(TermResolverBo.class, (Object)termResolverId);
        if (existing == null) {
            throw new IllegalStateException("the term resolver does not exist: " + termResolver);
        }
        if (!existing.getId().equals(termResolver.getId())) {
            TermResolverDefinition.Builder builder = TermResolverDefinition.Builder.create((TermResolverDefinitionContract)termResolver);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = termResolver;
        }
        TermResolverBo boToUpdate = TermResolverBo.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("termResolverId", toUpdate.getId());
        this.businessObjectService.deleteMatching(TermResolverAttributeBo.class, fields);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    public void deleteTermResolver(String id) throws RiceIllegalArgumentException {
        if (id == null) {
            throw new RiceIllegalArgumentException("agendaId is null");
        }
        TermSpecificationBo existing = (TermSpecificationBo)this.businessObjectService.findBySinglePrimaryKey(TermSpecificationBo.class, (Object)id);
        if (existing == null) {
            throw new IllegalStateException("the TermResolver to delete does not exists: " + id);
        }
        this.businessObjectService.delete((PersistableBusinessObject)existing);
    }

    public TermDefinition getTerm(String id) {
        TermDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermBo termBo = (TermBo)this.businessObjectService.findBySinglePrimaryKey(TermBo.class, (Object)id);
        if (termBo != null) {
            result = TermBo.to(termBo);
        }
        return result;
    }

    public TermResolverDefinition getTermResolverById(String id) {
        TermResolverDefinition result = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        TermResolverBo termResolverBo = (TermResolverBo)this.businessObjectService.findBySinglePrimaryKey(TermResolverBo.class, (Object)id);
        if (termResolverBo != null) {
            result = TermResolverBo.to(termResolverBo);
        }
        return result;
    }

    public List<TermResolverDefinition> findTermResolversByOutputId(String id, String namespace) {
        List<TermResolverDefinition> results = null;
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id must not be blank or null");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace must not be blank or null");
        }
        HashMap<String, String> criteria = new HashMap<String, String>(2);
        criteria.put("outputId", id);
        criteria.put("namespace", namespace);
        Collection termResolverBos = this.businessObjectService.findMatching(TermResolverBo.class, criteria);
        if (!CollectionUtils.isEmpty((Collection)termResolverBos)) {
            results = new ArrayList<TermResolverDefinition>(termResolverBos.size());
            for (TermResolverBo termResolverBo : termResolverBos) {
                results.add(TermResolverBo.to(termResolverBo));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public List<TermResolverDefinition> findTermResolversByNamespace(String namespace) {
        List<TermResolverDefinition> results = null;
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace must not be blank or null");
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("namespace", namespace);
        Collection termResolverBos = this.businessObjectService.findMatching(TermResolverBo.class, fieldValues);
        if (!CollectionUtils.isEmpty((Collection)termResolverBos)) {
            results = new ArrayList<TermResolverDefinition>(termResolverBos.size());
            for (TermResolverBo termResolverBo : termResolverBos) {
                if (termResolverBo == null) continue;
                results.add(TermResolverBo.to(termResolverBo));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public TermResolverDefinition getTermResolverByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        TermResolverBo bo = (TermResolverBo)this.businessObjectService.findByPrimaryKey(TermResolverBo.class, map);
        return TermResolverBo.to(bo);
    }

    public TermSpecificationDefinition getTermSpecificationByNameAndNamespace(String name, String namespace) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        TermSpecificationBo bo = (TermSpecificationBo)this.businessObjectService.findByPrimaryKey(TermSpecificationBo.class, map);
        return TermSpecificationBo.to(bo);
    }

    public List<TermSpecificationDefinition> findAllTermSpecificationsByContextId(String contextId) {
        List<TermSpecificationDefinition> results = null;
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId must not be blank or null");
        }
        Collection contextValidTerms = this.businessObjectService.findMatching(ContextValidTermBo.class, Collections.singletonMap("contextId", contextId));
        if (!CollectionUtils.isEmpty((Collection)contextValidTerms)) {
            results = new ArrayList<TermSpecificationDefinition>(contextValidTerms.size());
            for (ContextValidTermBo validTerm : contextValidTerms) {
                results.add(TermSpecificationBo.to(validTerm.getTermSpecification()));
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }
}

