/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krms.api.repository.operator.CustomOperator;

public class CustomOperatorUiTranslator {
    public QName parseCustomOperatorServiceQName(String customOperatorFormValue) {
        if (customOperatorFormValue == null || !this.isCustomOperatorFormValue(customOperatorFormValue)) {
            throw new IllegalArgumentException("custom operator form value (" + customOperatorFormValue + ") must be formatted as " + "customOperator:" + "namespace:serviceName");
        }
        String[] customOperatorServiceInfo = customOperatorFormValue.split(":");
        if (customOperatorServiceInfo == null || customOperatorServiceInfo.length != 3) {
            throw new IllegalArgumentException("custom operator form value (" + customOperatorFormValue + ") must be formatted as " + "customOperator:" + "namespace:serviceName");
        }
        QName customOperatorServiceQName = new QName(customOperatorServiceInfo[1], customOperatorServiceInfo[2]);
        return customOperatorServiceQName;
    }

    public String getCustomOperatorName(String customOperatorFormValue) {
        return this.getCustomOperator(customOperatorFormValue).getOperatorFunctionDefinition().getName();
    }

    public CustomOperator getCustomOperator(String customOperatorFormValue) {
        return (CustomOperator)GlobalResourceLoader.getService((QName)this.parseCustomOperatorServiceQName(customOperatorFormValue));
    }

    public boolean isCustomOperatorFormValue(String formValue) {
        if (StringUtils.isEmpty((String)formValue)) {
            return false;
        }
        return formValue.startsWith("customOperator:");
    }
}

