/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaAttributeBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaBoService;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.springframework.util.CollectionUtils;

public final class AgendaBoServiceImpl
implements AgendaBoService {
    private BusinessObjectService businessObjectService;
    private CriteriaLookupService criteriaLookupService;
    private KrmsAttributeDefinitionService attributeDefinitionService;
    private SequenceAccessorService sequenceAccessorService;
    private static final ModelObjectUtils.Transformer<AgendaItemBo, AgendaItemDefinition> toAgendaItemDefinition = new ModelObjectUtils.Transformer<AgendaItemBo, AgendaItemDefinition>(){

        public AgendaItemDefinition transform(AgendaItemBo input) {
            return AgendaItemBo.to(input);
        }
    };
    private static final ModelObjectUtils.Transformer<AgendaBo, AgendaDefinition> toAgendaDefinition = new ModelObjectUtils.Transformer<AgendaBo, AgendaDefinition>(){

        public AgendaDefinition transform(AgendaBo input) {
            return AgendaBo.to(input);
        }
    };

    @Override
    public AgendaDefinition createAgenda(AgendaDefinition agenda) {
        String contextId;
        if (agenda == null) {
            throw new RiceIllegalArgumentException("agenda is null");
        }
        String nameKey = agenda.getName();
        AgendaDefinition existing = this.getAgendaByNameAndContextId(nameKey, contextId = agenda.getContextId());
        if (existing != null) {
            throw new IllegalStateException("the agenda to create already exists: " + agenda);
        }
        AgendaBo agendaBo = this.from(agenda);
        this.businessObjectService.save((PersistableBusinessObject)agendaBo);
        return this.to(agendaBo);
    }

    @Override
    public void updateAgenda(AgendaDefinition agenda) {
        AgendaDefinition toUpdate;
        if (agenda == null) {
            throw new RiceIllegalArgumentException("agenda is null");
        }
        String agendaIdKey = agenda.getId();
        AgendaBo existing = (AgendaBo)this.businessObjectService.findBySinglePrimaryKey(AgendaBo.class, (Object)agendaIdKey);
        if (existing == null) {
            throw new IllegalStateException("the agenda does not exist: " + agenda);
        }
        if (existing.getId().equals(agenda.getId())) {
            toUpdate = agenda;
        } else {
            AgendaDefinition.Builder builder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agenda);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        }
        AgendaBo boToUpdate = this.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("agendaId", toUpdate.getId());
        this.businessObjectService.deleteMatching(AgendaAttributeBo.class, fields);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    @Override
    public void deleteAgenda(String agendaId) {
        if (agendaId == null) {
            throw new RiceIllegalArgumentException("agendaId is null");
        }
        AgendaBo bo = (AgendaBo)this.businessObjectService.findBySinglePrimaryKey(AgendaBo.class, (Object)agendaId);
        if (bo == null) {
            throw new IllegalStateException("the Agenda to delete does not exists: " + agendaId);
        }
        List<AgendaItemDefinition> agendaItems = this.getAgendaItemsByAgendaId(bo.getId());
        for (AgendaItemDefinition agendaItem : agendaItems) {
            this.businessObjectService.delete((PersistableBusinessObject)AgendaItemBo.from(agendaItem));
        }
        this.businessObjectService.delete((PersistableBusinessObject)bo);
    }

    @Override
    public AgendaDefinition getAgendaByAgendaId(String agendaId) {
        if (StringUtils.isBlank((String)agendaId)) {
            throw new RiceIllegalArgumentException("agenda id is null or blank");
        }
        AgendaBo bo = (AgendaBo)this.businessObjectService.findBySinglePrimaryKey(AgendaBo.class, (Object)agendaId);
        return this.to(bo);
    }

    @Override
    public AgendaDefinition getAgendaByNameAndContextId(String name, String contextId) {
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId is blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("contextId", contextId);
        AgendaBo myAgenda = (AgendaBo)this.businessObjectService.findByPrimaryKey(AgendaBo.class, Collections.unmodifiableMap(map));
        return this.to(myAgenda);
    }

    @Override
    public List<AgendaDefinition> getAgendasByContextId(String contextId) {
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("context ID is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextId);
        List bos = (List)this.businessObjectService.findMatching(AgendaBo.class, map);
        return this.convertAgendaBosToImmutables(bos);
    }

    @Override
    public AgendaItemDefinition createAgendaItem(AgendaItemDefinition agendaItem) {
        AgendaDefinition existing;
        if (agendaItem == null) {
            throw new RiceIllegalArgumentException("agendaItem is null");
        }
        if (agendaItem.getId() != null && (existing = this.getAgendaByAgendaId(agendaItem.getId())) != null) {
            throw new IllegalStateException("the agendaItem to create already exists: " + agendaItem);
        }
        AgendaItemBo bo = AgendaItemBo.from(agendaItem);
        this.businessObjectService.save((PersistableBusinessObject)bo);
        return AgendaItemBo.to(bo);
    }

    @Override
    public void updateAgendaItem(AgendaItemDefinition agendaItem) {
        AgendaItemDefinition toUpdate;
        if (agendaItem == null) {
            throw new RiceIllegalArgumentException("agendaItem is null");
        }
        String agendaItemIdKey = agendaItem.getId();
        AgendaItemDefinition existing = this.getAgendaItemById(agendaItemIdKey);
        if (existing == null) {
            throw new IllegalStateException("the agenda item does not exist: " + agendaItem);
        }
        if (existing.getId().equals(agendaItem.getId())) {
            toUpdate = agendaItem;
        } else {
            AgendaItemDefinition.Builder builder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        }
        AgendaItemBo aiBo = AgendaItemBo.from(toUpdate);
        this.updateActionAttributes(aiBo);
        this.businessObjectService.save((PersistableBusinessObject)aiBo);
    }

    private void updateActionAttributes(AgendaItemBo aiBo) {
        if (aiBo.getRule() != null) {
            this.updateActionAttributes(aiBo.getRule().getActions());
        }
        if (aiBo.getWhenTrue() != null) {
            this.updateActionAttributes(aiBo.getWhenTrue());
        }
        if (aiBo.getWhenFalse() != null) {
            this.updateActionAttributes(aiBo.getWhenFalse());
        }
        if (aiBo.getAlways() != null) {
            this.updateActionAttributes(aiBo.getAlways());
        }
    }

    private void updateActionAttributes(List<ActionBo> actionBos) {
        for (ActionBo action : actionBos) {
            for (ActionAttributeBo aa : action.getAttributeBos()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("actionId", action.getId());
                Collection aaBos = this.businessObjectService.findMatching(ActionAttributeBo.class, map);
                for (ActionAttributeBo aaBo : aaBos) {
                    if (!aaBo.getAttributeDefinitionId().equals(aa.getAttributeDefinitionId())) continue;
                    aa.setId(aaBo.getId());
                    aa.setVersionNumber(aaBo.getVersionNumber());
                }
            }
        }
    }

    @Override
    public void addAgendaItem(AgendaItemDefinition agendaItem, String parentId, Boolean position) {
        AgendaItemDefinition toCreate;
        if (agendaItem == null) {
            throw new RiceIllegalArgumentException("agendaItem is null");
        }
        AgendaItemDefinition parent = null;
        if (parentId != null && (parent = this.getAgendaItemById(parentId)) == null) {
            throw new IllegalStateException("parent agendaItem does not exist in repository. parentId = " + parentId);
        }
        if (agendaItem.getId() == null) {
            SequenceAccessorService sas = this.getSequenceAccessorService();
            AgendaItemDefinition.Builder builder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
            String newId = sas.getNextAvailableSequenceNumber("KRMS_AGENDA_ITM_S", AgendaItemBo.class).toString();
            builder.setId(newId);
            toCreate = builder.build();
        } else {
            toCreate = agendaItem;
        }
        this.createAgendaItem(toCreate);
        if (parentId != null) {
            AgendaItemDefinition.Builder builder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)parent);
            if (position == null) {
                builder.setAlwaysId(toCreate.getId());
            } else if (position.booleanValue()) {
                builder.setWhenTrueId(toCreate.getId());
            } else if (!position.booleanValue()) {
                builder.setWhenFalseId(toCreate.getId());
            }
            AgendaItemDefinition parentToUpdate = builder.build();
            this.updateAgendaItem(parentToUpdate);
        }
    }

    @Override
    public AgendaItemDefinition getAgendaItemById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("agenda item id is null or blank");
        }
        AgendaItemBo bo = (AgendaItemBo)this.businessObjectService.findBySinglePrimaryKey(AgendaItemBo.class, (Object)id);
        return AgendaItemBo.to(bo);
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByAgendaId(String agendaId) {
        if (StringUtils.isBlank((String)agendaId)) {
            throw new RiceIllegalArgumentException("agenda id is null or null");
        }
        List<Object> results = null;
        Collection bos = this.businessObjectService.findMatching(AgendaItemBo.class, Collections.singletonMap("agendaId", agendaId));
        results = CollectionUtils.isEmpty((Collection)bos) ? Collections.emptyList() : Collections.unmodifiableList(ModelObjectUtils.transform((Collection)bos, toAgendaItemDefinition));
        return results;
    }

    @Override
    public List<AgendaDefinition> getAgendasByType(String typeId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)typeId)) {
            throw new RiceIllegalArgumentException("type ID is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeId);
        List bos = (List)this.businessObjectService.findMatching(AgendaBo.class, map);
        return this.convertAgendaBosToImmutables(bos);
    }

    @Override
    public List<AgendaDefinition> getAgendasByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)typeId)) {
            throw new RiceIllegalArgumentException("type ID is null or blank");
        }
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("context ID is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeId);
        map.put("contextId", contextId);
        Collection bos = this.businessObjectService.findMatching(AgendaBo.class, map);
        return this.convertAgendaBosToImmutables(bos);
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByType(String typeId) throws RiceIllegalArgumentException {
        return this.findAgendaItemsForAgendas(this.getAgendasByType(typeId));
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByContext(String contextId) throws RiceIllegalArgumentException {
        return this.findAgendaItemsForAgendas(this.getAgendasByContextId(contextId));
    }

    @Override
    public List<AgendaItemDefinition> getAgendaItemsByTypeAndContext(String typeId, String contextId) throws RiceIllegalArgumentException {
        return this.findAgendaItemsForAgendas(this.getAgendasByTypeAndContext(typeId, contextId));
    }

    @Override
    public void deleteAgendaItem(String agendaItemId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)agendaItemId)) {
            throw new RiceIllegalArgumentException("agendaItemId must not be blank or null");
        }
        this.businessObjectService.deleteMatching(AgendaItemBo.class, Collections.singletonMap("id", agendaItemId));
    }

    private List<AgendaItemDefinition> findAgendaItemsForAgendas(List<AgendaDefinition> agendaDefinitions) {
        List<Object> results = null;
        if (!CollectionUtils.isEmpty(agendaDefinitions)) {
            ArrayList boResults = new ArrayList(agendaDefinitions.size());
            ArrayList<String> agendaIds = new ArrayList<String>(20);
            for (AgendaDefinition agendaDefinition : agendaDefinitions) {
                agendaIds.add(agendaDefinition.getId());
                if (agendaIds.size() != 20) continue;
                Predicate predicate = PredicateFactory.in((String)"agendaId", (Object[])agendaIds.toArray());
                QueryByCriteria criteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{predicate});
                GenericQueryResults batch = this.getCriteriaLookupService().lookup(AgendaItemBo.class, criteria);
                boResults.addAll(batch.getResults());
                agendaIds.clear();
            }
            if (agendaIds.size() > 0) {
                Predicate predicate = PredicateFactory.in((String)"agendaId", (Object[])agendaIds.toArray());
                QueryByCriteria criteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{predicate});
                GenericQueryResults batch = this.getCriteriaLookupService().lookup(AgendaItemBo.class, criteria);
                boResults.addAll(batch.getResults());
            }
            results = Collections.unmodifiableList(ModelObjectUtils.transform(boResults, toAgendaItemDefinition));
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public CriteriaLookupService getCriteriaLookupService() {
        if (this.criteriaLookupService == null) {
            this.criteriaLookupService = KrmsRepositoryServiceLocator.getCriteriaLookupService();
        }
        return this.criteriaLookupService;
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KRADServiceLocator.getSequenceAccessorService();
        }
        return this.sequenceAccessorService;
    }

    protected KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }

    public List<AgendaDefinition> convertAgendaBosToImmutables(Collection<AgendaBo> agendaBos) {
        if (CollectionUtils.isEmpty(agendaBos)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ModelObjectUtils.transform(agendaBos, toAgendaDefinition));
    }

    @Override
    public AgendaDefinition to(AgendaBo bo) {
        if (bo == null) {
            return null;
        }
        return AgendaDefinition.Builder.create((AgendaDefinitionContract)bo).build();
    }

    @Override
    public AgendaBo from(AgendaDefinition im) {
        if (im == null) {
            return null;
        }
        AgendaBo bo = new AgendaBo();
        bo.setId(im.getId());
        bo.setName(im.getName());
        bo.setTypeId(im.getTypeId());
        bo.setContextId(im.getContextId());
        bo.setFirstItemId(im.getFirstItemId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setActive(im.isActive());
        Set<AgendaAttributeBo> attributes = this.buildAgendaAttributeBo(im);
        bo.setAttributeBos(attributes);
        return bo;
    }

    private Set<AgendaAttributeBo> buildAgendaAttributeBo(AgendaDefinition im) {
        HashSet<AgendaAttributeBo> attributes = new HashSet<AgendaAttributeBo>();
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = this.getAttributeDefinitionService().findAttributeDefinitionsByType(im.getTypeId());
        for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
        }
        for (Map.Entry entry : im.getAttributes().entrySet()) {
            KrmsAttributeDefinition attrDef = (KrmsAttributeDefinition)attributeDefinitionMap.get(entry.getKey());
            if (attrDef != null) {
                AgendaAttributeBo attributeBo = new AgendaAttributeBo();
                attributeBo.setAgendaId(im.getId());
                attributeBo.setAttributeDefinitionId(attrDef.getId());
                attributeBo.setValue((String)entry.getValue());
                attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                attributes.add(attributeBo);
                continue;
            }
            throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the agenda type with id = '" + im.getTypeId() + "'");
        }
        return attributes;
    }
}

