/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.function.FunctionDefinitionContract;
import org.kuali.rice.krms.api.repository.function.FunctionRepositoryService;
import org.kuali.rice.krms.impl.repository.FunctionBo;
import org.kuali.rice.krms.impl.repository.FunctionBoService;

public class FunctionBoServiceImpl
implements FunctionRepositoryService,
FunctionBoService {
    private BusinessObjectService businessObjectService;
    private static final ModelObjectUtils.Transformer<FunctionBo, FunctionDefinition> toFunctionDefinition = new ModelObjectUtils.Transformer<FunctionBo, FunctionDefinition>(){

        public FunctionDefinition transform(FunctionBo input) {
            return FunctionBo.to(input);
        }
    };

    public FunctionDefinition getFunction(String functionId) {
        return this.getFunctionById(functionId);
    }

    public List<FunctionDefinition> getFunctions(List<String> functionIds) {
        if (functionIds == null) {
            throw new RiceIllegalArgumentException();
        }
        ArrayList<FunctionDefinition> functionDefinitions = new ArrayList<FunctionDefinition>();
        for (String functionId : functionIds) {
            FunctionDefinition functionDefinition;
            if (StringUtils.isBlank((String)functionId) || (functionDefinition = this.getFunctionById(functionId)) == null) continue;
            functionDefinitions.add(functionDefinition);
        }
        return Collections.unmodifiableList(functionDefinitions);
    }

    @Override
    public FunctionDefinition createFunction(FunctionDefinition function) {
        String namespaceKey;
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        String nameKey = function.getName();
        FunctionDefinition existing = this.getFunctionByNameAndNamespace(nameKey, namespaceKey = function.getNamespace());
        if (existing != null && existing.getName().equals(nameKey) && existing.getNamespace().equals(namespaceKey)) {
            throw new IllegalStateException("the function to create already exists: " + function);
        }
        FunctionBo functionBo = FunctionBo.from(function);
        this.businessObjectService.save((PersistableBusinessObject)functionBo);
        return FunctionBo.to(functionBo);
    }

    @Override
    public void updateFunction(FunctionDefinition function) {
        FunctionDefinition toUpdate;
        if (function == null) {
            throw new IllegalArgumentException("function is null");
        }
        String functionIdKey = function.getId();
        FunctionDefinition existing = this.getFunctionById(functionIdKey);
        if (existing == null) {
            throw new IllegalStateException("the function does not exist: " + function);
        }
        if (!existing.getId().equals(function.getId())) {
            FunctionDefinition.Builder builder = FunctionDefinition.Builder.create((FunctionDefinitionContract)function);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = function;
        }
        this.businessObjectService.save((PersistableBusinessObject)FunctionBo.from(toUpdate));
    }

    @Override
    public FunctionDefinition getFunctionById(String functionId) {
        if (StringUtils.isBlank((String)functionId)) {
            throw new RiceIllegalArgumentException("functionId is null or blank");
        }
        FunctionBo functionBo = (FunctionBo)this.businessObjectService.findBySinglePrimaryKey(FunctionBo.class, (Object)functionId);
        return FunctionBo.to(functionBo);
    }

    @Override
    public FunctionDefinition getFunctionByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        FunctionBo functionBo = (FunctionBo)this.businessObjectService.findByPrimaryKey(FunctionBo.class, Collections.unmodifiableMap(map));
        return FunctionBo.to(functionBo);
    }

    public List<FunctionDefinition> getFunctionsByNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        Collection functionBos = this.businessObjectService.findMatching(FunctionBo.class, map);
        return this.convertFunctionBosToImmutables(functionBos);
    }

    private List<FunctionDefinition> convertFunctionBosToImmutables(Collection<FunctionBo> functionBos) {
        if (CollectionUtils.isEmpty(functionBos)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ModelObjectUtils.transform(functionBos, toFunctionDefinition));
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

