/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateAttributeBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoService;
import org.kuali.rice.krms.impl.repository.language.SimpleNaturalLanguageTemplater;

public final class NaturalLanguageTemplateBoServiceImpl
implements NaturalLanguageTemplateBoService {
    private BusinessObjectService businessObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;
    private NaturalLanguageTemplaterContract naturalLanguageTemplater = new SimpleNaturalLanguageTemplater();

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }

    public KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    public NaturalLanguageTemplaterContract getNaturalLanguageTemplater() {
        return this.naturalLanguageTemplater;
    }

    public void setNaturalLanguageTemplater(NaturalLanguageTemplaterContract naturalLanguageTemplater) {
        this.naturalLanguageTemplater = naturalLanguageTemplater;
    }

    @Override
    public NaturalLanguageTemplate createNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) {
        this.incomingParamCheck(naturalLanguageTemplate, "naturalLanguageTemplate");
        String naturalLanguageTemplateIdKey = naturalLanguageTemplate.getId();
        NaturalLanguageTemplate existing = this.getNaturalLanguageTemplate(naturalLanguageTemplateIdKey);
        if (existing != null) {
            throw new IllegalStateException("the NaturalLanguageTemplate to create already exists: " + naturalLanguageTemplate);
        }
        NaturalLanguageTemplateBo bo = (NaturalLanguageTemplateBo)this.businessObjectService.save((PersistableBusinessObject)this.from(naturalLanguageTemplate));
        return NaturalLanguageTemplateBo.to(bo);
    }

    @Override
    public NaturalLanguageTemplate getNaturalLanguageTemplate(String naturalLanguageTemplateId) {
        this.incomingParamCheck(naturalLanguageTemplateId, "naturalLanguageTemplateId");
        NaturalLanguageTemplateBo bo = (NaturalLanguageTemplateBo)this.businessObjectService.findBySinglePrimaryKey(NaturalLanguageTemplateBo.class, (Object)naturalLanguageTemplateId);
        return NaturalLanguageTemplateBo.to(bo);
    }

    @Override
    public void updateNaturalLanguageTemplate(NaturalLanguageTemplate naturalLanguageTemplate) {
        NaturalLanguageTemplate toUpdate;
        this.incomingParamCheck(naturalLanguageTemplate, "naturalLanguageTemplate");
        NaturalLanguageTemplate existing = this.getNaturalLanguageTemplate(naturalLanguageTemplate.getId());
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageTemplate to update does not exists: " + naturalLanguageTemplate);
        }
        if (!existing.getId().equals(naturalLanguageTemplate.getId())) {
            NaturalLanguageTemplate.Builder builder = NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)naturalLanguageTemplate);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = naturalLanguageTemplate;
        }
        NaturalLanguageTemplateBo boToUpdate = this.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("naturalLanguageTemplateId", toUpdate.getId());
        this.businessObjectService.deleteMatching(NaturalLanguageTemplateAttributeBo.class, fields);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    @Override
    public void deleteNaturalLanguageTemplate(String naturalLanguageTemplateId) {
        this.incomingParamCheck(naturalLanguageTemplateId, "naturalLanguageTemplateId");
        NaturalLanguageTemplate existing = this.getNaturalLanguageTemplate(naturalLanguageTemplateId);
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageTemplate to delete does not exists: " + naturalLanguageTemplateId);
        }
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("naturalLanguageTemplateId", existing.getId());
        this.businessObjectService.deleteMatching(NaturalLanguageTemplateAttributeBo.class, fields);
        this.businessObjectService.delete((PersistableBusinessObject)this.from(existing));
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByAttributes(Map attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        HashMap<String, Map> map = new HashMap<String, Map>();
        map.put("attributes", attributes);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByLanguageCode(String languageCode) {
        if (StringUtils.isBlank((String)languageCode)) {
            throw new IllegalArgumentException("languageCode is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("languageCode", languageCode);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public NaturalLanguageTemplate findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(String languageCode, String typeId, String naturalLanguageUsageId) {
        if (StringUtils.isBlank((String)languageCode)) {
            throw new IllegalArgumentException("languageCode is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("languageCode", languageCode);
        map.put("naturalLanguageUsageId", naturalLanguageUsageId);
        map.put("typeId", typeId);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageTemplateBo.class, map);
        if (bos.isEmpty()) {
            return null;
        }
        if (bos.size() > 1) {
            throw new RiceIllegalArgumentException(languageCode + typeId + naturalLanguageUsageId + " is supposed to be unique");
        }
        return this.convertBosToImmutables(bos).get(0);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByNaturalLanguageUsage(String naturalLanguageUsageId) {
        if (StringUtils.isBlank((String)naturalLanguageUsageId)) {
            throw new IllegalArgumentException("naturalLanguageUsageId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("naturalLanguageUsageId", naturalLanguageUsageId);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByType(String typeId) {
        if (StringUtils.isBlank((String)typeId)) {
            throw new IllegalArgumentException("typeId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeId);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageTemplate> findNaturalLanguageTemplatesByTemplate(String template) {
        if (StringUtils.isBlank((String)template)) {
            throw new IllegalArgumentException("template is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("template", template);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageTemplateBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    public List<NaturalLanguageTemplate> convertBosToImmutables(Collection<NaturalLanguageTemplateBo> naturalLanguageTemplateBos) {
        LinkedList<NaturalLanguageTemplate> immutables = new LinkedList<NaturalLanguageTemplate>();
        if (naturalLanguageTemplateBos != null) {
            NaturalLanguageTemplate immutable = null;
            for (NaturalLanguageTemplateBo bo : naturalLanguageTemplateBos) {
                immutable = this.to(bo);
                immutables.add(immutable);
            }
        }
        return Collections.unmodifiableList(immutables);
    }

    @Override
    public NaturalLanguageTemplate to(NaturalLanguageTemplateBo naturalLanguageTemplateBo) {
        return NaturalLanguageTemplateBo.to(naturalLanguageTemplateBo);
    }

    @Override
    public NaturalLanguageTemplateBo from(NaturalLanguageTemplate naturalLanguageTemplate) {
        return NaturalLanguageTemplateBo.from(naturalLanguageTemplate);
    }

    private Collection<NaturalLanguageTemplateAttributeBo> buildAttributes(NaturalLanguageTemplate im, Collection<NaturalLanguageTemplateAttributeBo> attributes) {
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = this.getAttributeDefinitionService().findAttributeDefinitionsByType(im.getTypeId());
        for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
        }
        if (im.getAttributes() != null) {
            for (Map.Entry entry : im.getAttributes().entrySet()) {
                KrmsAttributeDefinition attrDef = (KrmsAttributeDefinition)attributeDefinitionMap.get(entry.getKey());
                if (attrDef != null) {
                    NaturalLanguageTemplateAttributeBo attributeBo = new NaturalLanguageTemplateAttributeBo();
                    attributeBo.setNaturalLanguageTemplateId(im.getId());
                    attributeBo.setAttributeDefinitionId(attrDef.getId());
                    attributeBo.setValue((String)entry.getValue());
                    attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                    attributes.add(attributeBo);
                    continue;
                }
                throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the naturalLanguageTemplate type with id = '" + im.getTypeId() + "'");
            }
        }
        return attributes;
    }

    private Set<NaturalLanguageTemplateAttributeBo> buildAttributeBoSet(NaturalLanguageTemplate im) {
        HashSet<NaturalLanguageTemplateAttributeBo> attributes = new HashSet<NaturalLanguageTemplateAttributeBo>();
        return (Set)this.buildAttributes(im, attributes);
    }

    private List<NaturalLanguageTemplateAttributeBo> buildAttributeBoList(NaturalLanguageTemplate im) {
        LinkedList<NaturalLanguageTemplateAttributeBo> attributes = new LinkedList<NaturalLanguageTemplateAttributeBo>();
        return (List)this.buildAttributes(im, attributes);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new IllegalArgumentException(name + " was blank");
        }
    }
}

