/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsageContract;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoService;

public final class NaturalLanguageUsageBoServiceImpl
implements NaturalLanguageUsageBoService {
    private BusinessObjectService businessObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }

    public KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    @Override
    public NaturalLanguageUsage createNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) {
        this.incomingParamCheck(naturalLanguageUsage, "naturalLanguageUsage");
        String naturalLanguageUsageIdKey = naturalLanguageUsage.getId();
        NaturalLanguageUsage existing = this.getNaturalLanguageUsage(naturalLanguageUsageIdKey);
        if (existing != null) {
            throw new IllegalStateException("the NaturalLanguageUsage to create already exists: " + naturalLanguageUsage);
        }
        NaturalLanguageUsageBo bo = (NaturalLanguageUsageBo)this.businessObjectService.save((PersistableBusinessObject)this.from(naturalLanguageUsage));
        return NaturalLanguageUsageBo.to(bo);
    }

    @Override
    public NaturalLanguageUsage getNaturalLanguageUsage(String naturalLanguageUsageId) {
        this.incomingParamCheck(naturalLanguageUsageId, "naturalLanguageUsageId");
        NaturalLanguageUsageBo bo = (NaturalLanguageUsageBo)this.businessObjectService.findBySinglePrimaryKey(NaturalLanguageUsageBo.class, (Object)naturalLanguageUsageId);
        return NaturalLanguageUsageBo.to(bo);
    }

    @Override
    public NaturalLanguageUsage getNaturalLanguageUsageByName(String namespace, String name) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceIllegalArgumentException("namespace was a null or blank value");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        map.put("name", name);
        NaturalLanguageUsageBo usageBo = (NaturalLanguageUsageBo)this.businessObjectService.findByPrimaryKey(NaturalLanguageUsageBo.class, Collections.unmodifiableMap(map));
        return NaturalLanguageUsageBo.to(usageBo);
    }

    @Override
    public void updateNaturalLanguageUsage(NaturalLanguageUsage naturalLanguageUsage) {
        NaturalLanguageUsage toUpdate;
        this.incomingParamCheck(naturalLanguageUsage, "naturalLanguageUsage");
        NaturalLanguageUsage existing = this.getNaturalLanguageUsage(naturalLanguageUsage.getId());
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageUsage to update does not exists: " + naturalLanguageUsage);
        }
        if (!existing.getId().equals(naturalLanguageUsage.getId())) {
            NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((NaturalLanguageUsageContract)naturalLanguageUsage);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = naturalLanguageUsage;
        }
        NaturalLanguageUsageBo boToUpdate = this.from(toUpdate);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    @Override
    public void deleteNaturalLanguageUsage(String naturalLanguageUsageId) {
        this.incomingParamCheck(naturalLanguageUsageId, "naturalLanguageUsageId");
        NaturalLanguageUsage existing = this.getNaturalLanguageUsage(naturalLanguageUsageId);
        if (existing == null) {
            throw new IllegalStateException("the NaturalLanguageUsage to delete does not exists: " + naturalLanguageUsageId);
        }
        this.businessObjectService.delete((PersistableBusinessObject)this.from(existing));
    }

    @Override
    public List<NaturalLanguageUsage> findNaturalLanguageUsagesByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageUsageBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageUsage> findNaturalLanguageUsagesByDescription(String description) {
        if (StringUtils.isBlank((String)description)) {
            throw new IllegalArgumentException("description is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("description", description);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageUsageBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<NaturalLanguageUsage> findNaturalLanguageUsagesByNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespace);
        List bos = (List)this.businessObjectService.findMatching(NaturalLanguageUsageBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    public List<NaturalLanguageUsage> convertBosToImmutables(Collection<NaturalLanguageUsageBo> naturalLanguageUsageBos) {
        LinkedList<NaturalLanguageUsage> immutables = new LinkedList<NaturalLanguageUsage>();
        if (naturalLanguageUsageBos != null) {
            NaturalLanguageUsage immutable = null;
            for (NaturalLanguageUsageBo bo : naturalLanguageUsageBos) {
                immutable = this.to(bo);
                immutables.add(immutable);
            }
        }
        return Collections.unmodifiableList(immutables);
    }

    @Override
    public NaturalLanguageUsage to(NaturalLanguageUsageBo naturalLanguageUsageBo) {
        return NaturalLanguageUsageBo.to(naturalLanguageUsageBo);
    }

    @Override
    public NaturalLanguageUsageBo from(NaturalLanguageUsage naturalLanguageUsage) {
        return NaturalLanguageUsageBo.from(naturalLanguageUsage);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new IllegalArgumentException(name + " was blank");
        }
    }
}

