/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.provider.repository;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.impl.type.KrmsTypeResolver;

final class LazyAction
implements Action {
    private final ActionDefinition actionDefinition;
    private final KrmsTypeResolver typeResolver;
    private final Object mutex = new Object();
    private volatile Action action;

    LazyAction(ActionDefinition actionDefinition, KrmsTypeResolver typeResolver) {
        this.actionDefinition = actionDefinition;
        this.typeResolver = typeResolver;
        this.action = null;
    }

    public void execute(ExecutionEnvironment environment) {
        this.getAction().execute(environment);
    }

    public void executeSimulation(ExecutionEnvironment environment) {
        this.getAction().executeSimulation(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Action getAction() {
        Action localAction = this.action;
        if (localAction == null) {
            Object object = this.mutex;
            synchronized (object) {
                localAction = this.action;
                if (localAction == null) {
                    this.action = localAction = this.constructAction();
                }
            }
        }
        return localAction;
    }

    private Action constructAction() {
        ActionTypeService actionTypeService = this.typeResolver.getActionTypeService(this.actionDefinition);
        Action action = actionTypeService.loadAction(this.actionDefinition);
        if (action == null) {
            action = new Action(){

                public void execute(ExecutionEnvironment environment) {
                }

                public void executeSimulation(ExecutionEnvironment environment) {
                }
            };
        }
        return action;
    }
}

