/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionBoService;
import org.kuali.rice.krms.impl.repository.PropositionParameterBo;

public final class PropositionBoServiceImpl
implements PropositionBoService {
    private BusinessObjectService businessObjectService;

    @Override
    public PropositionDefinition createProposition(PropositionDefinition prop) {
        if (prop == null) {
            throw new IllegalArgumentException("proposition is null");
        }
        if (null != prop.getId()) {
            throw new IllegalStateException("for creation, PropositionDefinition.id must be null");
        }
        PropositionBo propositionBo = PropositionBo.from(prop);
        this.businessObjectService.save((PersistableBusinessObject)propositionBo);
        return PropositionBo.to(propositionBo);
    }

    @Override
    public void updateProposition(PropositionDefinition prop) {
        PropositionDefinition toUpdate;
        if (prop == null) {
            throw new IllegalArgumentException("proposition is null");
        }
        String propIdKey = prop.getId();
        PropositionDefinition existing = this.getPropositionById(propIdKey);
        if (existing == null) {
            throw new IllegalStateException("the proposition does not exist: " + prop);
        }
        if (!existing.getId().equals(prop.getId())) {
            PropositionDefinition.Builder builder = PropositionDefinition.Builder.create((PropositionDefinitionContract)prop);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = prop;
        }
        this.businessObjectService.save((PersistableBusinessObject)PropositionBo.from(toUpdate));
    }

    @Override
    public PropositionDefinition getPropositionById(String propId) {
        if (StringUtils.isBlank((String)propId)) {
            throw new IllegalArgumentException("propId is null or blank");
        }
        PropositionBo bo = (PropositionBo)this.businessObjectService.findBySinglePrimaryKey(PropositionBo.class, (Object)propId);
        return PropositionBo.to(bo);
    }

    @Override
    public Set<PropositionDefinition> getPropositionsByType(String typeId) {
        if (StringUtils.isBlank((String)typeId)) {
            throw new IllegalArgumentException("typeId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("typeId", typeId);
        Collection bos = this.businessObjectService.findMatching(PropositionBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public Set<PropositionDefinition> getPropositionsByRule(String ruleId) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("ruleId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ruleId", ruleId);
        Collection bos = this.businessObjectService.findMatching(PropositionBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    public Set<PropositionDefinition> convertBosToImmutables(Collection<PropositionBo> propositionBos) {
        HashSet<PropositionDefinition> immutables = new HashSet<PropositionDefinition>();
        if (propositionBos != null) {
            PropositionDefinition immutable = null;
            for (PropositionBo bo : propositionBos) {
                immutable = this.to(bo);
                immutables.add(immutable);
            }
        }
        return Collections.unmodifiableSet(immutables);
    }

    public PropositionDefinition to(PropositionBo propositionBo) {
        return PropositionBo.to(propositionBo);
    }

    @Override
    public void createParameter(PropositionParameter parameter) {
        Integer seqNoKey;
        if (parameter == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        String propIdKey = parameter.getPropId();
        PropositionParameter existing = this.getParameterByPropIdAndSequenceNumber(propIdKey, seqNoKey = parameter.getSequenceNumber());
        if (existing != null && existing.getPropId().equals(propIdKey) && existing.getSequenceNumber().equals(seqNoKey)) {
            throw new IllegalStateException("the parameter to create already exists: " + parameter);
        }
        this.businessObjectService.save((PersistableBusinessObject)PropositionParameterBo.from(parameter));
    }

    @Override
    public void updateParameter(PropositionParameter parameter) {
        PropositionParameter toUpdate;
        Integer seqNoKey;
        if (parameter == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        String propIdKey = parameter.getPropId();
        PropositionParameter existing = this.getParameterByPropIdAndSequenceNumber(propIdKey, seqNoKey = parameter.getSequenceNumber());
        if (existing == null) {
            throw new IllegalStateException("the parameter does not exist: " + parameter);
        }
        if (!existing.getId().equals(parameter.getId())) {
            PropositionParameter.Builder builder = PropositionParameter.Builder.create((PropositionParameter)parameter);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = parameter;
        }
        this.businessObjectService.save((PersistableBusinessObject)PropositionParameterBo.from(toUpdate));
    }

    @Override
    public void deleteProposition(String propId) {
        if (propId == null) {
            throw new IllegalArgumentException("propId is null");
        }
        PropositionDefinition existing = this.getPropositionById(propId);
        if (existing == null) {
            throw new IllegalStateException("the Proposition to delete does not exists: " + propId);
        }
        List propositionParameters = existing.getParameters();
        for (PropositionParameter prop : propositionParameters) {
            this.businessObjectService.delete((PersistableBusinessObject)PropositionParameterBo.from(prop));
        }
        this.businessObjectService.delete((PersistableBusinessObject)this.from(existing));
    }

    @Override
    public List<PropositionParameter> getParameters(String propId) {
        if (StringUtils.isBlank((String)propId)) {
            throw new IllegalArgumentException("propId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("propId", propId);
        List bos = (List)this.businessObjectService.findMatchingOrderBy(PropositionParameterBo.class, map, "sequenceNumber", true);
        return PropositionParameterBo.to(bos);
    }

    @Override
    public PropositionParameter getParameterById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is null or blank");
        }
        PropositionParameterBo bo = (PropositionParameterBo)this.businessObjectService.findBySinglePrimaryKey(PropositionParameterBo.class, (Object)id);
        return PropositionParameterBo.to(bo);
    }

    @Override
    public PropositionParameter getParameterByPropIdAndSequenceNumber(String propId, Integer sequenceNumber) {
        if (StringUtils.isBlank((String)propId)) {
            throw new IllegalArgumentException("propId is null or blank");
        }
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("sequenceNumber is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propId", propId);
        map.put("sequenceNumber", sequenceNumber);
        PropositionParameterBo bo = (PropositionParameterBo)this.businessObjectService.findByPrimaryKey(PropositionParameterBo.class, map);
        return PropositionParameterBo.to(bo);
    }

    public PropositionBo from(PropositionDefinition proposition) {
        if (proposition == null) {
            return null;
        }
        PropositionBo propositionBo = new PropositionBo();
        propositionBo.setDescription(proposition.getDescription());
        propositionBo.setTypeId(proposition.getTypeId());
        propositionBo.setRuleId(proposition.getRuleId());
        propositionBo.setPropositionTypeCode(proposition.getPropositionTypeCode());
        propositionBo.setCompoundOpCode(proposition.getCompoundOpCode());
        propositionBo.setId(proposition.getId());
        propositionBo.setVersionNumber(proposition.getVersionNumber());
        return propositionBo;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

