/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.NaturalLanguageTree;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.TranslateBusinessMethods;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameter;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermParameterDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;

public class TranslationUtility
implements TranslateBusinessMethods {
    private RuleManagementService ruleManagementService;
    private TermRepositoryService termRepositoryService;
    private NaturalLanguageTemplaterContract templater;

    public TranslationUtility(RuleManagementService ruleManagementService, TermRepositoryService termRepositoryService, NaturalLanguageTemplaterContract templater) {
        this.ruleManagementService = ruleManagementService;
        this.termRepositoryService = termRepositoryService;
        this.templater = templater;
    }

    public RuleManagementService getRuleManagementService() {
        return this.ruleManagementService;
    }

    public void setRuleManagementService(RuleManagementService ruleManagementService) {
        this.ruleManagementService = ruleManagementService;
    }

    public NaturalLanguageTemplaterContract getTemplater() {
        return this.templater;
    }

    public void setTemplater(NaturalLanguageTemplaterContract templater) {
        this.templater = templater;
    }

    public String translateNaturalLanguageForObject(String naturalLanguageUsageId, String typeId, String krmsObjectId, String languageCode) throws RiceIllegalArgumentException {
        if (typeId.equals("agenda")) {
            AgendaDefinition agenda = this.ruleManagementService.getAgenda(krmsObjectId);
            if (agenda == null) {
                throw new RiceIllegalArgumentException(krmsObjectId + " is not an Id for an agenda");
            }
            return this.translateNaturalLanguageForAgenda(naturalLanguageUsageId, agenda, languageCode);
        }
        if (typeId.equals("rule")) {
            RuleDefinition rule = this.ruleManagementService.getRule(krmsObjectId);
            if (rule == null) {
                throw new RiceIllegalArgumentException(krmsObjectId + " is not an Id for a rule");
            }
            return this.translateNaturalLanguageForRule(naturalLanguageUsageId, rule, languageCode);
        }
        if (typeId.equals("proposition")) {
            PropositionDefinition proposition = this.ruleManagementService.getProposition(krmsObjectId);
            if (proposition == null) {
                throw new RiceIllegalArgumentException(krmsObjectId + " is not an Id for a proposition");
            }
            return this.translateNaturalLanguageForProposition(naturalLanguageUsageId, proposition, languageCode);
        }
        return "";
    }

    protected String translateNaturalLanguageForAgenda(String naturalLanguageUsageId, AgendaDefinition agenda, String languageCode) throws RiceIllegalArgumentException {
        if (agenda.getFirstItemId() == null) {
            throw new RiceIllegalArgumentException("Agenda has no first item");
        }
        AgendaItemDefinition item = this.ruleManagementService.getAgendaItem(agenda.getFirstItemId());
        return this.translateNaturalLanguageForAgendaItem(naturalLanguageUsageId, item, languageCode);
    }

    protected String translateNaturalLanguageForAgendaItem(String naturalLanguageUsageId, AgendaItemDefinition item, String languageCode) {
        if (item == null) {
            return "";
        }
        String naturalLanguage = "";
        if (item.getRuleId() != null) {
            RuleDefinition rule = this.ruleManagementService.getRule(item.getRuleId());
            naturalLanguage = naturalLanguage + this.translateNaturalLanguageForRule(naturalLanguageUsageId, rule, languageCode);
        }
        naturalLanguage = naturalLanguage + this.translateNaturalLanguageForAgendaItem(naturalLanguageUsageId, item.getWhenTrue(), languageCode);
        naturalLanguage = naturalLanguage + this.translateNaturalLanguageForAgendaItem(naturalLanguageUsageId, item.getWhenFalse(), languageCode);
        naturalLanguage = naturalLanguage + this.translateNaturalLanguageForAgendaItem(naturalLanguageUsageId, item.getAlways(), languageCode);
        return naturalLanguage;
    }

    protected String translateNaturalLanguageForRule(String naturalLanguageUsageId, RuleDefinition rule, String languageCode) throws RiceIllegalArgumentException {
        if (rule == null) {
            return "";
        }
        NaturalLanguageTemplate nlTemplate = this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(languageCode, rule.getTypeId(), naturalLanguageUsageId);
        String naturalLanguage = nlTemplate.getTemplate() + " ";
        if (rule.getProposition() != null) {
            naturalLanguage = naturalLanguage + this.translateNaturalLanguageForProposition(naturalLanguageUsageId, rule.getProposition(), languageCode);
        }
        return naturalLanguage;
    }

    public String translateNaturalLanguageForProposition(String naturalLanguageUsageId, PropositionDefinition proposition, String languageCode) throws RiceIllegalArgumentException {
        return this.translateNaturalLanguageForProposition(naturalLanguageUsageId, proposition, languageCode, true) + ". ";
    }

    private String translateNaturalLanguageForProposition(String naturalLanguageUsageId, PropositionDefinition proposition, String languageCode, boolean isRoot) {
        NaturalLanguageTemplate naturalLanguageTemplate = this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(languageCode, proposition.getTypeId(), naturalLanguageUsageId);
        StringBuilder naturalLanguage = new StringBuilder();
        if (proposition.getPropositionTypeCode().equals(PropositionType.SIMPLE.getCode())) {
            if (naturalLanguageTemplate != null) {
                Map<String, Object> contextMap = this.buildSimplePropositionContextMap(proposition);
                naturalLanguage.append(this.templater.translate(naturalLanguageTemplate, contextMap));
            }
        } else if (proposition.getPropositionTypeCode().equals(PropositionType.COMPOUND.getCode())) {
            if (naturalLanguageTemplate != null) {
                Map<String, Object> contextMap = this.buildCompoundPropositionContextMap(naturalLanguageUsageId, proposition, languageCode);
                naturalLanguage.append(this.templater.translate(naturalLanguageTemplate, contextMap));
            }
            if (proposition.getCompoundComponents() != null) {
                String operator = this.getCompoundSeperator(proposition, isRoot);
                for (PropositionDefinition child : proposition.getCompoundComponents()) {
                    if (proposition.getCompoundComponents().indexOf(child) != 0) {
                        naturalLanguage.append(operator);
                    }
                    naturalLanguage.append(this.translateNaturalLanguageForProposition(naturalLanguageUsageId, child, languageCode, false));
                }
            }
        } else {
            throw new RiceIllegalArgumentException("Unknown proposition type: " + proposition.getPropositionTypeCode());
        }
        return naturalLanguage.toString();
    }

    private String getCompoundSeperator(PropositionDefinition proposition, boolean isRoot) {
        String operator = this.getCompoundOperator(proposition);
        if (isRoot) {
            return ". " + StringUtils.capitalize((String)operator) + " ";
        }
        return "; " + operator + " ";
    }

    private String getCompoundOperator(PropositionDefinition proposition) {
        String operator = null;
        if (LogicalOperator.AND.getCode().equalsIgnoreCase(proposition.getCompoundOpCode())) {
            operator = "and";
        } else if (LogicalOperator.OR.getCode().equalsIgnoreCase(proposition.getCompoundOpCode())) {
            operator = "or";
        }
        return operator;
    }

    public NaturalLanguageTree translateNaturalLanguageTreeForProposition(String naturalLanguageUsageId, PropositionDefinition proposition, String languageCode) throws RiceIllegalArgumentException {
        NaturalLanguageTemplate naturalLanguageTemplate = this.getNaturalLanguageTemplateForProposition(naturalLanguageUsageId, proposition, languageCode);
        NaturalLanguageTree.Builder tree = NaturalLanguageTree.Builder.create();
        if (proposition.getPropositionTypeCode().equals(PropositionType.SIMPLE.getCode())) {
            Map<String, Object> contextMap = this.buildSimplePropositionContextMap(proposition);
            String naturalLanguage = this.templater.translate(naturalLanguageTemplate, contextMap);
            tree.setNaturalLanguage(naturalLanguage);
        } else if (proposition.getPropositionTypeCode().equals(PropositionType.COMPOUND.getCode())) {
            Map<String, Object> contextMap = this.buildCompoundPropositionContextMap(naturalLanguageUsageId, proposition, languageCode);
            String naturalLanguage = this.templater.translate(naturalLanguageTemplate, contextMap);
            tree.setNaturalLanguage(naturalLanguage);
            if (proposition.getCompoundComponents() != null) {
                ArrayList<NaturalLanguageTree> children = new ArrayList<NaturalLanguageTree>();
                for (PropositionDefinition child : proposition.getCompoundComponents()) {
                    children.add(this.translateNaturalLanguageTreeForProposition(naturalLanguageUsageId, child, languageCode));
                }
                tree.setChildren(children);
            }
        } else {
            throw new RiceIllegalArgumentException("Unknown proposition type: " + proposition.getPropositionTypeCode());
        }
        return tree.build();
    }

    protected NaturalLanguageTemplate getNaturalLanguageTemplateForProposition(String naturalLanguageUsageId, PropositionDefinition proposition, String languageCode) {
        NaturalLanguageTemplate naturalLanguageTemplate = null;
        if (proposition.getTypeId() != null) {
            naturalLanguageTemplate = this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(languageCode, proposition.getTypeId(), naturalLanguageUsageId);
        }
        return naturalLanguageTemplate;
    }

    protected Map<String, Object> buildSimplePropositionContextMap(PropositionDefinition proposition) {
        if (!proposition.getPropositionTypeCode().equals(PropositionType.SIMPLE.getCode())) {
            throw new RiceIllegalArgumentException("proposition is not simple " + proposition.getPropositionTypeCode() + " " + proposition.getId() + proposition.getDescription());
        }
        LinkedHashMap<String, Object> contextMap = new LinkedHashMap<String, Object>();
        for (PropositionParameter param : proposition.getParameters()) {
            if (param.getParameterType().equals(PropositionParameterType.TERM.getCode())) {
                TermDefinition term = param.getTermValue();
                if (term == null && StringUtils.isNotBlank((String)param.getValue())) {
                    term = this.termRepositoryService.getTerm(param.getValue());
                }
                if (term != null) {
                    for (TermParameterDefinition termParam : term.getParameters()) {
                        contextMap.put(termParam.getName(), termParam.getValue());
                    }
                    continue;
                }
                contextMap.put(param.getParameterType(), param.getValue());
                continue;
            }
            contextMap.put(param.getParameterType(), param.getValue());
        }
        return contextMap;
    }

    protected Map<String, Object> buildCompoundPropositionContextMap(String naturalLanguageUsageId, PropositionDefinition proposition, String languageCode) {
        if (!proposition.getPropositionTypeCode().equals(PropositionType.COMPOUND.getCode())) {
            throw new RiceIllegalArgumentException("proposition us not compound " + proposition.getPropositionTypeCode() + " " + proposition.getId() + proposition.getDescription());
        }
        return new LinkedHashMap<String, Object>();
    }
}

