/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.impl.repository.CategoryBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;

public class TermSpecBusRule
extends MaintenanceDocumentRuleBase {
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean isValid = true;
        TermSpecificationBo termSpec = (TermSpecificationBo)((Object)document.getNewMaintainableObject().getDataObject());
        isValid &= this.validateId(termSpec);
        isValid &= this.validateCategory(termSpec);
        isValid &= this.validateContext(termSpec);
        return isValid &= this.validateNameNamespace(termSpec);
    }

    private boolean validateCategory(TermSpecificationBo termSpecificationBo) {
        List<CategoryBo> categories = termSpecificationBo.getCategories();
        ArrayList<String> categoryIds = new ArrayList<String>();
        boolean valid = true;
        for (CategoryBo category : categories) {
            if (categoryIds.contains(category.getId())) {
                this.putFieldError("dataObject.categoryId", "error.termSpecification.duplicateCategory");
                valid = false;
                continue;
            }
            categoryIds.add(category.getId());
        }
        return valid;
    }

    private boolean validateContext(TermSpecificationBo termSpec) {
        List<ContextBo> termSpecContexts = termSpec.getContexts();
        ArrayList<String> contextIds = new ArrayList<String>();
        boolean valid = true;
        for (ContextBo context : termSpecContexts) {
            if (contextIds.contains(context.getId())) {
                this.putFieldError("dataObject.contextId", "error.termSpecification.duplicateContext");
                valid = false;
                continue;
            }
            contextIds.add(context.getId());
        }
        return valid;
    }

    private boolean validateId(TermSpecificationBo termSpec) {
        TermSpecificationDefinition termSpecInDatabase;
        if (StringUtils.isNotBlank((String)termSpec.getId()) && (termSpecInDatabase = this.getTermBoService().getTermSpecificationById(termSpec.getId())) != null && !StringUtils.equals((String)termSpecInDatabase.getId(), (String)termSpec.getId())) {
            this.putFieldError("dataObject.id", "error.termSpecification.duplicateId");
            return false;
        }
        return true;
    }

    private boolean validateNameNamespace(TermSpecificationBo termSpec) {
        if (StringUtils.isNotBlank((String)termSpec.getName()) && StringUtils.isNotBlank((String)termSpec.getNamespace())) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("name", termSpec.getName());
            criteria.put("namespace", termSpec.getNamespace());
            TermSpecificationBo termSpecInDatabase = (TermSpecificationBo)this.getBoService().findByPrimaryKey(TermSpecificationBo.class, criteria);
            if (termSpecInDatabase != null && !StringUtils.equals((String)termSpecInDatabase.getId(), (String)termSpec.getId())) {
                this.putFieldError("dataObject.name", "error.term.duplicateNameNamespace");
                return false;
            }
        }
        return true;
    }

    public TermBoService getTermBoService() {
        return KrmsRepositoryServiceLocator.getTermBoService();
    }
}

