/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.jws.WebParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.framework.type.ValidationActionService;
import org.kuali.rice.krms.framework.type.ValidationActionType;
import org.kuali.rice.krms.framework.type.ValidationActionTypeService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.type.KrmsTypeServiceBase;
import org.kuali.rice.krms.impl.validation.RadioButtonTypeServiceUtil;
import org.kuali.rice.krms.impl.validation.ValidationAction;

public class ValidationActionTypeServiceImpl
extends KrmsTypeServiceBase
implements ValidationActionTypeService {
    private ValidationActionService validationService;

    private ValidationActionTypeServiceImpl() {
    }

    public static ActionTypeService getInstance() {
        return new ValidationActionTypeServiceImpl();
    }

    public Action loadAction(ActionDefinition validationActionDefinition) {
        if (validationActionDefinition == null) {
            throw new RiceIllegalArgumentException("validationActionDefinition must not be null");
        }
        if (validationActionDefinition.getAttributes() == null) {
            throw new RiceIllegalArgumentException("validationActionDefinition must not be null");
        }
        if (!validationActionDefinition.getAttributes().containsKey("actionTypeCode")) {
            throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionTypeCode attribute");
        }
        String validationActionTypeCode = (String)validationActionDefinition.getAttributes().get("actionTypeCode");
        if (StringUtils.isBlank((String)validationActionTypeCode)) {
            throw new RiceIllegalArgumentException("actionTypeCode attribute must not be null or blank");
        }
        if (!validationActionDefinition.getAttributes().containsKey("actionMessage")) {
            throw new RiceIllegalArgumentException("validationActionDefinition does not contain an actionMessage attribute");
        }
        String validationMessage = (String)validationActionDefinition.getAttributes().get("actionMessage");
        if (StringUtils.isBlank((String)validationMessage)) {
            throw new RiceIllegalArgumentException("actionMessage attribute must not be null or blank");
        }
        if (ValidationActionType.WARNING.getCode().equals(validationActionTypeCode)) {
            return new ValidationAction(ValidationActionType.WARNING, validationMessage);
        }
        if (ValidationActionType.ERROR.getCode().equals(validationActionTypeCode)) {
            return new ValidationAction(ValidationActionType.ERROR, validationMessage);
        }
        return null;
    }

    @Override
    public List<RemotableAttributeField> getAttributeFields(@WebParam(name="krmsTypeId") String krmsTypeId) throws RiceIllegalArgumentException {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        KrmsTypeDefinition krmsType = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
        if (krmsType == null) {
            throw new RiceIllegalArgumentException("krmsTypeId must be a valid id of a KRMS type");
        }
        List typeAttributes = krmsType.getAttributes();
        TreeMap attribDefIdSequenceNumbers = new TreeMap();
        TreeMap unsortedIdLables = new TreeMap();
        if (!CollectionUtils.isEmpty((Collection)typeAttributes)) {
            TreeMap<String, String> keyLabels = new TreeMap<String, String>();
            keyLabels.put(ValidationActionType.WARNING.getCode(), "Warning Action");
            keyLabels.put(ValidationActionType.ERROR.getCode(), "Error Action");
            KrmsTypeRepositoryService typeRepositoryService = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
            KrmsAttributeDefinition attributeDefinition = null;
            RadioButtonTypeServiceUtil util = new RadioButtonTypeServiceUtil();
            for (KrmsTypeAttribute typeAttribute : typeAttributes) {
                RemotableAttributeField attributeField;
                attributeDefinition = typeRepositoryService.getAttributeDefinitionById(typeAttribute.getAttributeDefinitionId());
                if ("actionTypeCode".equals(attributeDefinition.getName())) {
                    attributeField = util.translateTypeAttribute(attributeDefinition, keyLabels);
                    results.add(attributeField);
                }
                if (!"actionMessage".equals(attributeDefinition.getName())) continue;
                attributeField = this.createMessageField(attributeDefinition);
                results.add(attributeField);
            }
        }
        return results;
    }

    private RemotableAttributeField createMessageField(KrmsAttributeDefinition krmsAttributeDefinition) {
        RemotableTextarea.Builder controlBuilder = RemotableTextarea.Builder.create();
        controlBuilder = RemotableTextarea.Builder.create();
        controlBuilder.setRows(Integer.valueOf(2));
        controlBuilder.setCols(Integer.valueOf(30));
        controlBuilder.setWatermark("Enter a Validation Action Message");
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)krmsAttributeDefinition.getName());
        builder.setRequired(true);
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel(krmsAttributeDefinition.getLabel());
        builder.setShortLabel("Message");
        builder.setMinLength(Integer.valueOf(1));
        builder.setMaxLength(Integer.valueOf(400));
        return builder.build();
    }

    public void setValidationService(ValidationActionService mockValidationService) {
        if (mockValidationService == null) {
            throw new RiceIllegalArgumentException("validationService must not be null");
        }
        this.validationService = mockValidationService;
    }
}

