/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaAttributeBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AgendaItemBoTest {
    private AgendaItemBo testObject;
    @Mock
    KrmsTypeRepositoryService mockKrmsTypeRepositoryService;
    @Mock
    DataObjectService mockDataObjectService;
    @Mock
    RepositoryBoIncrementer mockRepositoryBoIncrementer;
    @Mock
    RuleBo mockRuleBo;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObject = new AgendaItemBo();
        Mockito.when((Object)this.mockKrmsTypeRepositoryService.getTypeById((String)Mockito.any(String.class))).thenReturn((Object)KrmsTypeDefinition.Builder.create((String)"name", (String)"namespace").build());
        Mockito.when((Object)this.mockDataObjectService.copyInstance(Mockito.any(AgendaItemBo.class), new CopyOption[]{(CopyOption)Mockito.any(CopyOption.class), (CopyOption)Mockito.any(CopyOption.class)})).thenReturn((Object)this.getAgendaItemBoFull("A", "B", "C", "D")).thenReturn((Object)this.getAgendaItemBo("A", "B", "C", this.getRuleBo("H", "I", "J", "K", null)));
        Mockito.when((Object)this.mockRepositoryBoIncrementer.getNewId()).thenReturn((Object)"NEW_ID");
        this.testObject.setKrmsTypeRepositoryService(this.mockKrmsTypeRepositoryService);
        this.testObject.setDataObjectService(this.mockDataObjectService);
        AgendaItemBo.agendaItemIdIncrementer = this.mockRepositoryBoIncrementer;
    }

    @Test
    public void testFromNullParameter() {
        Assert.assertNull((Object)AgendaItemBo.from(null));
    }

    @Test
    public void testToNullParameter() {
        Assert.assertNull((Object)AgendaItemBo.to(null));
    }

    @Test
    public void testTo() {
        AgendaItemBo data = new AgendaItemBo();
        data.setId("A");
        data.setAgendaId("B");
        data.setVersionNumber(Long.valueOf(0L));
        data.setRule(this.getRuleBo("C", "D", "E", "F", null));
        data.setSubAgendaId("G");
        data.setWhenTrue(this.getAgendaItemBo("H", "I", "J", this.getRuleBo("K", "L", "M", "N", null)));
        data.setWhenFalse(this.getAgendaItemBo("O", "P", "Q", this.getRuleBo("R", "S", "T", "U", null)));
        data.setAlways(this.getAgendaItemBo("V", "W", "X", this.getRuleBo("Y", "Z", "AA", "AB", null)));
        AgendaItemDefinition result = AgendaItemBo.to((AgendaItemBo)data);
        Assert.assertEquals((Object)"A", (Object)result.getId());
        Assert.assertEquals((Object)"B", (Object)result.getAgendaId());
        Assert.assertEquals((Object)"C", (Object)result.getRuleId());
        Assert.assertEquals((Object)"G", (Object)result.getSubAgendaId());
        Assert.assertEquals((Object)"J", (Object)result.getWhenTrueId());
        Assert.assertEquals((Object)"Q", (Object)result.getWhenFalseId());
        Assert.assertEquals((Object)"X", (Object)result.getAlwaysId());
        Assert.assertEquals((long)0L, (long)result.getVersionNumber());
        Assert.assertNotNull((Object)result.getRule());
        Assert.assertNotNull((Object)result.getWhenTrue());
        Assert.assertNotNull((Object)result.getWhenFalse());
        Assert.assertNotNull((Object)result.getAlways());
    }

    @Test
    public void testFrom() {
        AgendaItemBo data = AgendaItemBo.from((AgendaItemDefinition)this.getAgendItemDefinitionBuilder());
        Assert.assertEquals((Object)"A", (Object)data.getId());
        Assert.assertEquals((Object)"B", (Object)data.getAgendaId());
        Assert.assertEquals((Object)"H", (Object)data.getRuleId());
        Assert.assertEquals((Object)"D", (Object)data.getSubAgendaId());
        Assert.assertEquals((Object)"Q", (Object)data.getWhenTrueId());
        Assert.assertEquals((Object)"S", (Object)data.getWhenFalseId());
        Assert.assertEquals((Object)"U", (Object)data.getAlwaysId());
        Assert.assertEquals((long)0L, (long)data.getVersionNumber());
        Assert.assertNotNull((Object)data.getRule());
        Assert.assertNotNull((Object)data.getWhenTrue());
        Assert.assertNotNull((Object)data.getWhenFalse());
        Assert.assertNotNull((Object)data.getAlways());
    }

    @Test
    public void testGetUl() {
        AgendaItemBo obj = new AgendaItemBo();
        AgendaItemBo agenda = this.getAgendaItemBo("A", "B", "C", this.getRuleBo("H", "I", "J", "K", null));
        this.testObject.setRule(agenda.getRule());
        this.testObject.setWhenTrue(agenda.getWhenTrue());
        this.testObject.setWhenFalse(agenda.getWhenFalse());
        this.testObject.setAlways(agenda.getAlways());
        String result = this.testObject.getUl(obj);
        Assert.assertEquals((Object)"<ul><li>H</li></ul>", (Object)result);
    }

    @Test
    public void testGetUlHelper() {
        AgendaItemBo obj = new AgendaItemBo();
        this.testObject.setAgendaId("B");
        this.testObject.setId("A");
        this.testObject.setVersionNumber(Long.valueOf(0L));
        this.testObject.setRule(this.getRuleBo("ID", "NAME", "NAMESPACE", "DESCRIPTION", null));
        this.testObject.setSubAgendaId("D");
        String result = this.testObject.getUlHelper(obj);
        Assert.assertEquals((Object)"<li>ID</li>", (Object)result);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetRuleTextInvalidParameter() {
        this.testObject.getRuleText();
    }

    @Test
    public void testGetRuleTextValidParameterUnnamedRule() {
        ArrayList<ActionBo> actionList = new ArrayList<ActionBo>();
        ActionBo action = new ActionBo();
        action.setName("A");
        action.setTypeId("B");
        action.setNamespace("C");
        action.setSequenceNumber(Integer.valueOf(1));
        actionList.add(action);
        this.testObject.setRule(this.getRuleBo("D", "", "E", "F", actionList));
        String result = this.testObject.getRuleText();
        Assert.assertEquals((Object)"- unnamed rule -: F   [name: A]", (Object)result);
    }

    @Test
    public void testGetRuleTextValidParameterSingleAction() {
        ArrayList<ActionBo> actionList = new ArrayList<ActionBo>();
        ActionBo action = new ActionBo();
        action.setName("A");
        action.setTypeId("B");
        action.setNamespace("C");
        action.setSequenceNumber(Integer.valueOf(1));
        actionList.add(action);
        this.testObject.setRule(this.getRuleBo("D", "E", "F", "G", actionList));
        String result = this.testObject.getRuleText();
        Assert.assertEquals((Object)"E: G   [name: A]", (Object)result);
    }

    @Test
    public void testGetRuleTextValidParameterMultipleAction() {
        ArrayList<ActionBo> actionList = new ArrayList<ActionBo>();
        ActionBo action1 = new ActionBo();
        action1.setName("ActionName1");
        action1.setTypeId("ActionType1");
        action1.setNamespace("ActionNamespace1");
        action1.setSequenceNumber(Integer.valueOf(1));
        actionList.add(action1);
        ActionBo action2 = new ActionBo();
        action2.setName("ActionName2");
        action2.setTypeId("ActionType2");
        action2.setNamespace("ActionNamespace2");
        action2.setSequenceNumber(Integer.valueOf(2));
        actionList.add(action2);
        this.testObject.setRule(this.getRuleBo("ID", "NAME", "NAMESPACE", "DESCRIPTION", actionList));
        String result = this.testObject.getRuleText();
        Assert.assertEquals((Object)"NAME: DESCRIPTION   [name: ActionName1 ... ]", (Object)result);
    }

    @Test
    public void testCopyAgendaItemValidParameter1() {
        RuleBo ruleBo = this.getRuleBo("ID", "NAME", "NAMESPACE", "DESCRIPTION", null);
        ContextBo contextBo = this.createContext("NAME", "NAMEPSACE");
        KrmsAttributeDefinitionBo eventAttributeDefinition = this.createEventAttributeDefinition("NAME", "NAMESPACE");
        AgendaBo copiedAgenda = this.createAgenda(ruleBo, contextBo, eventAttributeDefinition);
        HashMap oldRuleIdToNew = new HashMap();
        HashMap oldAgendaItemIdToNew = new HashMap();
        ArrayList copiedAgendaItems = new ArrayList();
        String dts = "";
        Mockito.when((Object)this.mockRuleBo.getId()).thenReturn((Object)"ID");
        Mockito.when((Object)this.mockRuleBo.copyRule((String)Mockito.any(String.class))).thenReturn((Object)this.getRuleBo("ID", "NAME", "NAMESPACE", "DESCRIPTION", null));
        this.testObject.setRule(this.mockRuleBo);
        this.testObject.setId(this.mockRuleBo.getId());
        AgendaItemBo agendaItemBo1 = this.getAgendaItemBo("A", "B", "C", this.mockRuleBo);
        AgendaItemBo agendaItemBo2 = this.getAgendaItemBo("D", "E", "F", this.mockRuleBo);
        AgendaItemBo agendaItemBo3 = this.getAgendaItemBo("G", "H", "I", this.mockRuleBo);
        this.testObject.setWhenFalse(agendaItemBo1);
        this.testObject.setWhenFalseId(agendaItemBo1.getId());
        this.testObject.setWhenTrue(agendaItemBo2);
        this.testObject.setWhenTrueId(agendaItemBo2.getId());
        this.testObject.setAlways(agendaItemBo3);
        this.testObject.setAlwaysId(agendaItemBo3.getId());
        this.testObject.copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts);
        AgendaItemBo result = this.testObject.copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts);
        Assert.assertNotNull((Object)result);
        Assert.assertNull((Object)result.getAlways());
        Assert.assertNull((Object)result.getWhenTrue());
        Assert.assertNull((Object)result.getWhenFalse());
        Assert.assertNotNull((Object)result.getRule());
        Assert.assertEquals((Object)"NEW_ID", (Object)result.getId());
        Assert.assertEquals((Object)"B", (Object)result.getSubAgendaId());
    }

    @Test
    public void testCopyAgendaItemValidParameter2() {
        RuleBo ruleBo = this.getRuleBo("ID", "NAME", "NAMESPACE", "DESCRIPTION", null);
        ContextBo contextBo = this.createContext("NAME", "NAMEPSACE");
        KrmsAttributeDefinitionBo eventAttributeDefinition = this.createEventAttributeDefinition("NAME", "NAMESPACE");
        AgendaBo copiedAgenda = this.createAgenda(ruleBo, contextBo, eventAttributeDefinition);
        HashMap oldRuleIdToNew = new HashMap();
        HashMap oldAgendaItemIdToNew = new HashMap();
        ArrayList copiedAgendaItems = new ArrayList();
        String dts = "";
        Mockito.when((Object)this.mockRuleBo.getId()).thenReturn((Object)"C");
        Mockito.when((Object)this.mockRuleBo.copyRule((String)Mockito.any(String.class))).thenReturn((Object)this.getRuleBo("C", "NAME", "NAMESPACE", "DESCRIPTION", null));
        this.testObject.setRule(this.mockRuleBo);
        this.testObject.setId(this.mockRuleBo.getId());
        AgendaItemBo agendaItemBo1 = this.getAgendaItemBo("A", "B", "C", this.mockRuleBo);
        AgendaItemBo agendaItemBo2 = this.getAgendaItemBo("A", "D", "C", this.mockRuleBo);
        AgendaItemBo agendaItemBo3 = this.getAgendaItemBo("A", "B", "C", this.mockRuleBo);
        this.testObject.setWhenFalse(agendaItemBo1);
        this.testObject.setWhenFalseId(agendaItemBo1.getId());
        this.testObject.setWhenTrue(agendaItemBo2);
        this.testObject.setWhenTrueId(agendaItemBo2.getId());
        this.testObject.setAlways(agendaItemBo3);
        this.testObject.setAlwaysId(agendaItemBo3.getId());
        AgendaItemBo result = this.testObject.copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getAlways());
        Assert.assertNotNull((Object)result.getWhenTrue());
        Assert.assertNotNull((Object)result.getWhenFalse());
        Assert.assertNotNull((Object)result.getRule());
        Assert.assertEquals((Object)"NEW_ID", (Object)result.getId());
        Assert.assertEquals((Object)"NEW_ID", (Object)result.getAlwaysId());
        Assert.assertEquals((Object)"NEW_ID", (Object)result.getWhenTrueId());
        Assert.assertEquals((Object)"NEW_ID", (Object)result.getWhenFalseId());
        Assert.assertEquals((Object)"D", (Object)result.getSubAgendaId());
    }

    @Test
    public void testGetAlwaysList() {
        AgendaItemBo agendaItemBo1 = this.getAgendaItemBo("A", "B", "C", null);
        AgendaItemBo agendaItemBo2 = this.getAgendaItemBo("D", "E", "F", null);
        agendaItemBo2.setAlways(agendaItemBo1);
        AgendaItemBo agendaItemBo3 = this.getAgendaItemBo("G", "H", "I", null);
        agendaItemBo3.setAlways(agendaItemBo2);
        this.testObject.setAlways(agendaItemBo3);
        List result = this.testObject.getAlwaysList();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.size());
    }

    private ContextBo createContext(String name, String namespace) {
        KrmsTypeDefinition.Builder typeDefinition = KrmsTypeDefinition.Builder.create((String)name, (String)namespace);
        typeDefinition.setId("ID");
        KrmsTypeDefinition defaultContextType = typeDefinition.build();
        ContextBo contextBo = new ContextBo();
        contextBo.setNamespace("KR-RULE");
        contextBo.setName("MyContext");
        contextBo.setTypeId(defaultContextType.getId());
        return contextBo;
    }

    private KrmsAttributeDefinitionBo createEventAttributeDefinition(String name, String namespace) {
        KrmsAttributeDefinitionBo attributeDefinitionBo = new KrmsAttributeDefinitionBo();
        attributeDefinitionBo.setNamespace(namespace);
        attributeDefinitionBo.setName(name);
        attributeDefinitionBo.setLabel("Event");
        attributeDefinitionBo.setActive(true);
        return attributeDefinitionBo;
    }

    private AgendaBo createAgenda(RuleBo ruleBo, ContextBo contextBo, KrmsAttributeDefinitionBo eventAttributeDefinition) {
        AgendaBo agendaBo = new AgendaBo();
        agendaBo.setActive(true);
        agendaBo.setContextId(contextBo.getId());
        agendaBo.setName("MyAgenda");
        agendaBo.setTypeId(null);
        AgendaItemBo agendaItemBo = this.getAgendaItemBo("A", "B", "C", this.getRuleBo("H", "I", "J", "K", null));
        ArrayList<AgendaItemBo> agendaItems = new ArrayList<AgendaItemBo>();
        agendaItems.add(agendaItemBo);
        agendaBo.setItems(agendaItems);
        agendaBo.setFirstItemId(agendaItemBo.getId());
        agendaBo.setFirstItem(agendaItemBo);
        HashSet<AgendaAttributeBo> agendaAttributes = new HashSet<AgendaAttributeBo>();
        agendaBo.setAttributeBos(agendaAttributes);
        AgendaAttributeBo agendaAttribute = new AgendaAttributeBo();
        agendaAttributes.add(agendaAttribute);
        agendaAttribute.setAttributeDefinition(eventAttributeDefinition);
        agendaAttribute.setValue("workflow");
        agendaAttribute.setAgenda(agendaBo);
        contextBo.getAgendas().add(agendaBo);
        return agendaBo;
    }

    private RuleBo getRuleBo(String id, String name, String namespace, String description, List<ActionBo> actionList) {
        RuleBo obj = new RuleBo();
        obj.setId(id);
        obj.setName(name);
        obj.setNamespace(namespace);
        obj.setDescription(description);
        obj.setActions(actionList);
        return obj;
    }

    private AgendaItemBo getAgendaItemBoFull(String id, String name, String namespace, String description) {
        AgendaItemBo obj = new AgendaItemBo();
        obj.setAgendaId("B");
        obj.setId("A");
        obj.setVersionNumber(Long.valueOf(0L));
        obj.setRule(this.getRuleBo(id, name, namespace, description, null));
        obj.setSubAgendaId("D");
        obj.setWhenTrue(this.getAgendaItemBo("A", "B", "C", this.getRuleBo("H", "I", "J", "K", null)));
        obj.setWhenFalse(this.getAgendaItemBo("A", "B", "C", this.getRuleBo("H", "I", "J", "K", null)));
        obj.setAlways(this.getAgendaItemBo("A", "B", "C", this.getRuleBo("H", "I", "J", "K", null)));
        return obj;
    }

    private AgendaItemBo getAgendaItemBo(String agendaId, String sunAgendaId, String id, RuleBo rule) {
        AgendaItemBo obj = new AgendaItemBo();
        obj.setAgendaId(agendaId);
        obj.setId(id);
        obj.setVersionNumber(Long.valueOf(0L));
        obj.setRule(rule);
        obj.setSubAgendaId(sunAgendaId);
        obj.setWhenTrue(null);
        obj.setWhenFalse(null);
        obj.setAlways(null);
        obj.setDataObjectService(this.mockDataObjectService);
        return obj;
    }

    private AgendaItemDefinition getAgendItemDefinitionBuilder() {
        AgendaItemDefinition.Builder itemDefinition = AgendaItemDefinition.Builder.create((String)"A", (String)"B");
        itemDefinition.setRuleId("C");
        itemDefinition.setSubAgendaId("D");
        itemDefinition.setWhenTrueId("E");
        itemDefinition.setWhenFalseId("F");
        itemDefinition.setAlwaysId("G");
        itemDefinition.setRule(RuleDefinition.Builder.create((String)"H", (String)"I", (String)"J", (String)"K", (String)"L"));
        itemDefinition.setSubAgenda(AgendaDefinition.Builder.create((String)"M", (String)"N", (String)"O", (String)"P"));
        itemDefinition.setWhenTrue(AgendaItemDefinition.Builder.create((String)"Q", (String)"R"));
        itemDefinition.setWhenFalse(AgendaItemDefinition.Builder.create((String)"S", (String)"T"));
        itemDefinition.setAlways(AgendaItemDefinition.Builder.create((String)"U", (String)"V"));
        itemDefinition.setVersionNumber(Long.valueOf(0L));
        return itemDefinition.build();
    }
}

