/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.KrmsTypeGenTest;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public final class KrmsTypeBoServiceImplGenTest {
    private KrmsTypeBoServiceImpl service;
    @Mock
    private KrmsAttributeDefinitionService mockAttributeService;
    @Mock
    private DataObjectService mockDataObjectService;
    KrmsTypeDefinition krmsType;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.service = new KrmsTypeBoServiceImpl();
        this.service.setDataObjectService(this.mockDataObjectService);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getTypeById_null_fail() {
        this.service.getTypeById(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getTypeByName_null_fail() {
        this.service.getTypeByName(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllTypesByNamespace_null_fail() {
        this.service.findAllTypesByNamespace(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllAgendaTypesByContextId_null_fail() {
        this.service.findAllAgendaTypesByContextId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAgendaTypeByAgendaTypeIdAndContextId_null_fail() {
        this.service.getAgendaTypeByAgendaTypeIdAndContextId(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllRuleTypesByContextId_null_fail() {
        this.service.findAllRuleTypesByContextId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getRuleTypeByRuleTypeIdAndContextId_null_fail() {
        this.service.getRuleTypeByRuleTypeIdAndContextId(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllActionTypesByContextId_null_fail() {
        this.service.findAllActionTypesByContextId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getActionTypeByActionTypeIdAndContextId_null_fail() {
        this.service.getActionTypeByActionTypeIdAndContextId(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAttributeDefinitionById_null_fail() {
        this.service.getAttributeDefinitionById(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAttributeDefinitionByName_null_fail() {
        this.service.getAttributeDefinitionByName(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createKrmsType_null_fail() {
        this.service.createKrmsType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateKrmsType_null_fail() {
        this.service.updateKrmsType(null);
    }

    @Test
    public void test_createKrmsType() {
        KrmsTypeDefinition def = KrmsTypeGenTest.buildFullKrmsTypeDefinition();
        this.krmsType = this.service.getTypeByName(def.getNamespace(), def.getName());
        if (this.krmsType == null) {
            this.krmsType = this.service.createKrmsType(def);
        }
    }

    public KrmsTypeDefinition getKrmsType() {
        return this.krmsType;
    }

    public KrmsTypeDefinition getKrmsTypeDefinition() {
        return this.getKrmsType();
    }

    public void setKrmsTypeBoServiceImpl(KrmsTypeBoServiceImpl impl) {
        this.service = impl;
    }

    public static KrmsTypeBoServiceImplGenTest create(KrmsTypeBoServiceImpl impl) {
        KrmsTypeBoServiceImplGenTest test = new KrmsTypeBoServiceImplGenTest();
        test.setKrmsTypeBoServiceImpl(impl);
        return test;
    }
}

