/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.AndPredicate;
import org.kuali.rice.core.api.criteria.EqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.GreaterThanPredicate;
import org.kuali.rice.core.api.criteria.LessThanOrEqualPredicate;
import org.kuali.rice.core.api.criteria.LessThanPredicate;
import org.kuali.rice.core.api.criteria.LikePredicate;
import org.kuali.rice.core.api.criteria.OrPredicate;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.QueryByCriteria;

public class CriteriaMatcherInMemory<T> {
    private QueryByCriteria criteria;
    private transient Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    public QueryByCriteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(QueryByCriteria criteria) {
        this.criteria = criteria;
    }

    public Collection<T> findMatching(Collection<T> all) {
        if (this.criteria == null) {
            return all;
        }
        int count = -1;
        int startAt = 0;
        if (this.criteria.getStartAtIndex() != null) {
            startAt = this.criteria.getStartAtIndex();
        }
        int maxResults = Integer.MAX_VALUE;
        if (this.criteria.getMaxResults() != null) {
            maxResults = this.criteria.getMaxResults();
        }
        ArrayList<T> selected = new ArrayList<T>();
        for (T obj : all) {
            if (!this.matches(obj) || ++count < startAt) continue;
            selected.add(obj);
            if (count <= maxResults) continue;
            break;
        }
        return selected;
    }

    public boolean matches(T infoObject) {
        return this.matches(infoObject, this.criteria.getPredicate());
    }

    protected boolean matches(T infoObject, Predicate predicate) {
        if (predicate == null) {
            return true;
        }
        if (predicate instanceof OrPredicate) {
            return this.matchesOr(infoObject, (OrPredicate)predicate);
        }
        if (predicate instanceof AndPredicate) {
            return this.matchesAnd(infoObject, (AndPredicate)predicate);
        }
        if (predicate instanceof EqualPredicate) {
            return this.matchesEqual(infoObject, (EqualPredicate)predicate);
        }
        if (predicate instanceof LessThanPredicate) {
            return this.matchesLessThan(infoObject, (LessThanPredicate)predicate);
        }
        if (predicate instanceof LessThanOrEqualPredicate) {
            return this.matchesLessThanOrEqual(infoObject, (LessThanOrEqualPredicate)predicate);
        }
        if (predicate instanceof GreaterThanPredicate) {
            return this.matchesGreaterThan(infoObject, (GreaterThanPredicate)predicate);
        }
        if (predicate instanceof GreaterThanOrEqualPredicate) {
            return this.matchesGreaterThanOrEqual(infoObject, (GreaterThanOrEqualPredicate)predicate);
        }
        if (predicate instanceof LikePredicate) {
            return this.matchesLike(infoObject, (LikePredicate)predicate);
        }
        throw new UnsupportedOperationException("predicate type not supported yet in in-memory mathcer" + predicate.getClass().getName());
    }

    private boolean matchesOr(T infoObject, OrPredicate predicate) {
        for (Predicate subPred : predicate.getPredicates()) {
            if (!this.matches(infoObject, subPred)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesAnd(T infoObject, AndPredicate predicate) {
        for (Predicate subPred : predicate.getPredicates()) {
            if (this.matches(infoObject, subPred)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesEqual(T infoObject, EqualPredicate predicate) {
        Object dataValue = CriteriaMatcherInMemory.extractValue(predicate.getPropertyPath(), infoObject);
        return CriteriaMatcherInMemory.matchesEqual(dataValue, predicate.getValue().getValue());
    }

    private boolean matchesLessThan(T infoObject, LessThanPredicate predicate) {
        Object dataValue = CriteriaMatcherInMemory.extractValue(predicate.getPropertyPath(), infoObject);
        return CriteriaMatcherInMemory.matchesLessThan(dataValue, predicate.getValue().getValue());
    }

    private boolean matchesLessThanOrEqual(T infoObject, LessThanOrEqualPredicate predicate) {
        Object dataValue = CriteriaMatcherInMemory.extractValue(predicate.getPropertyPath(), infoObject);
        if (CriteriaMatcherInMemory.matchesLessThan(dataValue, predicate.getValue().getValue())) {
            return true;
        }
        return CriteriaMatcherInMemory.matchesEqual(dataValue, predicate.getValue().getValue());
    }

    private boolean matchesGreaterThan(T infoObject, GreaterThanPredicate predicate) {
        Object dataValue = CriteriaMatcherInMemory.extractValue(predicate.getPropertyPath(), infoObject);
        return CriteriaMatcherInMemory.matchesGreaterThan(dataValue, predicate.getValue().getValue());
    }

    private boolean matchesGreaterThanOrEqual(T infoObject, GreaterThanOrEqualPredicate predicate) {
        Object dataValue = CriteriaMatcherInMemory.extractValue(predicate.getPropertyPath(), infoObject);
        if (CriteriaMatcherInMemory.matchesGreaterThan(dataValue, predicate.getValue().getValue())) {
            return true;
        }
        return CriteriaMatcherInMemory.matchesEqual(dataValue, predicate.getValue().getValue());
    }

    private boolean matchesLike(T infoObject, LikePredicate predicate) {
        Object dataValue = CriteriaMatcherInMemory.extractValue(predicate.getPropertyPath(), infoObject);
        return this.matchesLike(dataValue, predicate.getValue().getValue());
    }

    protected static Object extractValue(String fieldPath, Object infoObject) {
        try {
            if (infoObject == null) {
                return null;
            }
            Object value = PropertyUtils.getNestedProperty((Object)infoObject, (String)fieldPath);
            if (value instanceof Boolean) {
                return value.toString();
            }
            if (value instanceof Date) {
                return new DateTime((Object)((Date)value));
            }
            if (value instanceof Calendar) {
                return new DateTime((Object)((Calendar)value));
            }
            if (value instanceof Short) {
                return BigInteger.valueOf(((Short)value).longValue());
            }
            if (value instanceof AtomicLong) {
                return BigInteger.valueOf(((AtomicLong)value).longValue());
            }
            if (value instanceof AtomicInteger) {
                return BigInteger.valueOf(((AtomicInteger)value).longValue());
            }
            if (value instanceof Integer) {
                return BigInteger.valueOf(((Integer)value).longValue());
            }
            if (value instanceof Long) {
                return BigInteger.valueOf((Long)value);
            }
            if (value instanceof Float) {
                return BigDecimal.valueOf(((Float)value).doubleValue());
            }
            if (value instanceof Double) {
                return BigDecimal.valueOf((Double)value);
            }
            return value;
        }
        catch (NestedNullException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(fieldPath, ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(fieldPath, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(fieldPath, ex);
        }
    }

    public static boolean matchesEqual(Object dataValue, Object criteriaValue) {
        if (dataValue == criteriaValue) {
            return true;
        }
        if (dataValue == null && criteriaValue == null) {
            return true;
        }
        if (dataValue == null) {
            return false;
        }
        return dataValue.equals(criteriaValue);
    }

    public static boolean matchesLessThan(Object dataValue, Object criteriaValue) {
        if (dataValue == criteriaValue) {
            return false;
        }
        if (dataValue == null && criteriaValue == null) {
            return false;
        }
        if (dataValue == null) {
            return false;
        }
        if (criteriaValue instanceof Comparable) {
            Comparable comp1 = (Comparable)dataValue;
            Comparable comp2 = (Comparable)criteriaValue;
            return comp1.compareTo(comp2) < 0;
        }
        throw new IllegalArgumentException("The values are not comparable " + criteriaValue);
    }

    public static boolean matchesGreaterThan(Object dataValue, Object criteriaValue) {
        if (dataValue == criteriaValue) {
            return false;
        }
        if (dataValue == null && criteriaValue == null) {
            return false;
        }
        if (dataValue == null) {
            return false;
        }
        if (criteriaValue instanceof Comparable) {
            Comparable comp1 = (Comparable)dataValue;
            Comparable comp2 = (Comparable)criteriaValue;
            return comp1.compareTo(comp2) > 0;
        }
        throw new IllegalArgumentException("The values are not comparable " + criteriaValue);
    }

    private Pattern getPattern(String expr) {
        Pattern p = this.patternCache.get(expr);
        if (p == null) {
            p = CriteriaMatcherInMemory.compilePattern(expr);
            this.patternCache.put(expr, p);
        }
        return p;
    }

    public boolean matchesLike(Object dataValue, Object criteriaValue) {
        if (dataValue == criteriaValue) {
            return false;
        }
        if (dataValue == null && criteriaValue == null) {
            return false;
        }
        if (dataValue == null) {
            return false;
        }
        return this.matchesLikeCachingPattern(dataValue.toString(), criteriaValue.toString());
    }

    public boolean matchesLikeCachingPattern(String str, String expr) {
        return CriteriaMatcherInMemory.matchesLike(str, this.getPattern(expr));
    }

    private static Pattern compilePattern(String expr) {
        String regex = CriteriaMatcherInMemory.quotemeta(expr);
        regex = regex.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 32);
        return p;
    }

    public static boolean matchesLike(String str, String expr) {
        Pattern p = CriteriaMatcherInMemory.compilePattern(expr);
        return CriteriaMatcherInMemory.matchesLike(str, p);
    }

    private static boolean matchesLike(String str, Pattern p) {
        return p.matcher(str).matches();
    }

    private static String quotemeta(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ("[](){}.*+?$^|#\\".indexOf(c) != -1) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

