/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.peopleflow;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebParam;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.TermResolutionEngine;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.engine.BasicExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.TermResolutionEngineImpl;
import org.kuali.rice.krms.impl.peopleflow.PeopleFlowActionTypeService;
import org.springframework.orm.ObjectRetrievalFailureException;

public class PeopleFlowActionTypeServiceTest {
    private final PeopleFlowActionTypeService notificationPFATS = PeopleFlowActionTypeService.getInstance((PeopleFlowActionTypeService.Type)PeopleFlowActionTypeService.Type.NOTIFICATION);
    private final PeopleFlowActionTypeService approvalPFATS = PeopleFlowActionTypeService.getInstance((PeopleFlowActionTypeService.Type)PeopleFlowActionTypeService.Type.APPROVAL);
    private static final String VALID_PEOPLEFLOW_ID_1 = "myBogusPeopleFlowId1";
    private static final String VALID_PEOPLEFLOW_NAME_1 = "myBogusPeopleFlowName1";
    private static final String VALID_PEOPLEFLOW_ID_2 = "myBogusPeopleFlowId2";
    private static final String VALID_PEOPLEFLOW_NAME_2 = "myBogusPeopleFlowName2";
    private static final String INVALID_PEOPLEFLOW_ID = "invalidPeopleFlowId";
    private static final ConfigurationService configurationService = new ConfigurationService(){

        public String getPropertyValueAsString(String key) {
            return "{0} message";
        }

        public boolean getPropertyValueAsBoolean(String key) {
            return false;
        }

        public boolean getPropertyValueAsBoolean(String key, boolean defaultValue) {
            return false;
        }

        public Map<String, String> getAllProperties() {
            return null;
        }
    };
    private final PeopleFlowService mockPeopleFlowService = new PeopleFlowService(){
        private Set<String> validPeopleFlowIds = new HashSet<String>();
        {
            this.validPeopleFlowIds.add(PeopleFlowActionTypeServiceTest.VALID_PEOPLEFLOW_ID_1);
            this.validPeopleFlowIds.add(PeopleFlowActionTypeServiceTest.VALID_PEOPLEFLOW_ID_2);
        }

        public PeopleFlowDefinition getPeopleFlow(@WebParam(name="peopleFlowId") String peopleFlowId) throws RiceIllegalArgumentException {
            if (this.validPeopleFlowIds.contains(peopleFlowId)) {
                return PeopleFlowDefinition.Builder.create((String)"myNamespace", (String)"myPeopleFlowName").build();
            }
            throw new ObjectRetrievalFailureException("", (Throwable)new RuntimeException());
        }

        public PeopleFlowDefinition getPeopleFlowByName(@WebParam(name="namespaceCode") String namespaceCode, @WebParam(name="name") String name) throws RiceIllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        public PeopleFlowDefinition createPeopleFlow(@WebParam(name="peopleFlow") PeopleFlowDefinition peopleFlow) throws RiceIllegalArgumentException, RiceIllegalStateException {
            throw new UnsupportedOperationException();
        }

        public PeopleFlowDefinition updatePeopleFlow(@WebParam(name="peopleFlow") PeopleFlowDefinition peopleFlow) throws RiceIllegalArgumentException, RiceIllegalStateException {
            throw new UnsupportedOperationException();
        }
    };

    @Before
    public void injectConfigurationService() {
        this.notificationPFATS.setConfigurationService(configurationService);
        this.approvalPFATS.setConfigurationService(configurationService);
    }

    @Test(expected=RiceIllegalArgumentException.class)
    public void testNullActionDefinition() {
        this.notificationPFATS.loadAction(null);
    }

    @Test
    public void testActionExecution() {
        ActionDefinition.Builder actionDefinitionBuilder = ActionDefinition.Builder.create((String)"myId", (String)"myName", (String)"myNamespace", (String)"myTypeId", (String)"myRuleId", (Integer)0);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("peopleFlowId", VALID_PEOPLEFLOW_ID_1);
        attributes.put("peopleFlowName", VALID_PEOPLEFLOW_NAME_1);
        actionDefinitionBuilder.setAttributes(attributes);
        SelectionCriteria sc1 = SelectionCriteria.createCriteria((DateTime)new DateTime(), Collections.emptyMap(), Collections.singletonMap("Event", "foo"));
        BasicExecutionEnvironment ee = new BasicExecutionEnvironment(sc1, Collections.emptyMap(), new ExecutionOptions(), (TermResolutionEngine)new TermResolutionEngineImpl());
        Action notificationAction = this.notificationPFATS.loadAction(actionDefinitionBuilder.build());
        notificationAction.execute((ExecutionEnvironment)ee);
        attributes.clear();
        attributes.put("peopleFlowId", VALID_PEOPLEFLOW_ID_2);
        attributes.put("peopleFlowName", VALID_PEOPLEFLOW_NAME_2);
        actionDefinitionBuilder.setAttributes(attributes);
        Action approvalAction = this.approvalPFATS.loadAction(actionDefinitionBuilder.build());
        approvalAction.execute((ExecutionEnvironment)ee);
        String selectedPeopleFlows = (String)ee.getEngineResults().getAttribute("peopleFlowsSelected");
        Assert.assertEquals((Object)"F:myBogusPeopleFlowId1,A:myBogusPeopleFlowId2", (Object)selectedPeopleFlows);
        String selectedPeopleName = (String)ee.getEngineResults().getAttribute("peopleFlowName");
        actionDefinitionBuilder.setAttributes(Collections.emptyMap());
        try {
            this.approvalPFATS.loadAction(actionDefinitionBuilder.build());
            Assert.fail((String)"should have blown up since the attribute we need isn't in the ActionDefinition");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateAttributes() {
        PeopleFlowActionTypeService peopleFlowActionTypeService = PeopleFlowActionTypeService.getInstance((PeopleFlowActionTypeService.Type)PeopleFlowActionTypeService.Type.NOTIFICATION);
        peopleFlowActionTypeService.setConfigurationService(configurationService);
        peopleFlowActionTypeService.setPeopleFlowService(this.mockPeopleFlowService);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("peopleFlowId", INVALID_PEOPLEFLOW_ID);
        try {
            peopleFlowActionTypeService.validateAttributes(null, attributes);
            Assert.fail((String)"null type id should throw an exception");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            peopleFlowActionTypeService.validateAttributes("bogusTypeId", null);
            Assert.fail((String)"null type id should throw an exception");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        List errors = peopleFlowActionTypeService.validateAttributes("bogusTypeId", attributes);
        Assert.assertFalse((boolean)CollectionUtils.isEmpty((Collection)errors));
        errors = peopleFlowActionTypeService.validateAttributesAgainstExisting("bogusTypeId", attributes, Collections.emptyMap());
        Assert.assertFalse((boolean)CollectionUtils.isEmpty((Collection)errors));
        attributes.clear();
        attributes.put("peopleFlowId", VALID_PEOPLEFLOW_ID_1);
        errors = peopleFlowActionTypeService.validateAttributes("bogusTypeId", attributes);
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)errors));
        errors = peopleFlowActionTypeService.validateAttributesAgainstExisting("bogusTypeId", attributes, Collections.emptyMap());
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)errors));
    }
}

