/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.NaturalLanguageUsageGenTest;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoServiceImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NaturalLanguageUsageBoServiceImplGenTest {
    private NaturalLanguageUsageBoServiceImpl service;
    private NaturalLanguageUsage naturalLanguageUsage;
    private DataObjectService mockDataObjectService = (DataObjectService)Mockito.mock(DataObjectService.class);

    @Before
    public void setUp() {
        this.service = new NaturalLanguageUsageBoServiceImpl();
        this.service.setDataObjectService(this.mockDataObjectService);
    }

    @Test
    public void test_createNaturalLanguageUsage() {
        NaturalLanguageUsage def = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage();
        this.naturalLanguageUsage = this.service.getNaturalLanguageUsageByName(def.getNamespace(), def.getName());
        if (this.naturalLanguageUsage == null) {
            this.naturalLanguageUsage = this.service.createNaturalLanguageUsage(def);
        }
    }

    @Test
    public void test_createNaturalLanguageUsageGeneratedId() {
        NaturalLanguageUsage def = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsageNoId();
        this.naturalLanguageUsage = this.service.createNaturalLanguageUsage(def);
    }

    @Test
    public void test_createNaturalLanguageUsage_GeneratedId_success() {
        NaturalLanguageUsageBo saveResult = this.service.from(NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage());
        Mockito.when((Object)this.mockDataObjectService.findMatching((Class)Matchers.any(Class.class), (QueryByCriteria)Matchers.any(QueryByCriteria.class))).thenReturn(null);
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(NaturalLanguageUsageBo.class), new PersistenceOption[]{(PersistenceOption)Matchers.any(PersistenceOption.class)})).thenReturn((Object)saveResult);
        NaturalLanguageUsage def = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsageNoId();
        this.naturalLanguageUsage = this.service.createNaturalLanguageUsage(def);
        Assert.assertNotNull((Object)this.naturalLanguageUsage);
    }

    @Test
    public void test_getNaturalLanguageUsageByName_success() {
        GenericQueryResults.Builder findMatchingResult = GenericQueryResults.Builder.create();
        ArrayList<NaturalLanguageUsageBo> resultList = new ArrayList<NaturalLanguageUsageBo>();
        NaturalLanguageUsageBo e = this.service.from(NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage());
        resultList.add(e);
        findMatchingResult.setResults(resultList);
        Mockito.when((Object)this.mockDataObjectService.findMatching((Class)Matchers.any(Class.class), (QueryByCriteria)Matchers.any(QueryByCriteria.class))).thenReturn((Object)findMatchingResult);
        NaturalLanguageUsage def = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage();
        this.naturalLanguageUsage = this.service.getNaturalLanguageUsageByName(def.getNamespace(), def.getName());
        Assert.assertNotNull((Object)this.naturalLanguageUsage);
    }

    @Test
    public void test_updateNaturalLanguageUsage_success() {
        NaturalLanguageUsage data = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage();
        NaturalLanguageUsage findResult = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage();
        NaturalLanguageUsageBo saveResult = this.service.from(NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage());
        Mockito.when((Object)this.mockDataObjectService.find((Class)Matchers.any(Class.class), Matchers.any(String.class))).thenReturn((Object)this.service.from(findResult));
        Mockito.when((Object)this.mockDataObjectService.save(Matchers.any(NaturalLanguageUsageBo.class), new PersistenceOption[]{(PersistenceOption)Matchers.any(PersistenceOption.class)})).thenReturn((Object)saveResult);
        NaturalLanguageUsage updatedData = this.service.updateNaturalLanguageUsage(data);
        Assert.assertNotNull((Object)updatedData);
    }

    @Test
    public void test_from_null_yields_null() {
        Assert.assertNull((Object)this.service.from(null));
    }

    @Test
    public void test_from() {
        NaturalLanguageUsage def = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage();
        NaturalLanguageUsageBo def2 = this.service.from(def);
        Assert.assertEquals((Object)def2.getName(), (Object)def.getName());
        Assert.assertEquals((Object)def2.getNamespace(), (Object)def.getNamespace());
        Assert.assertEquals((Object)def2.getId(), (Object)def.getId());
    }

    @Test
    public void test_to() {
        NaturalLanguageUsage def = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage();
        NaturalLanguageUsageBo naturalLanguageUsageBo = this.service.from(def);
        NaturalLanguageUsage def2 = NaturalLanguageUsageBo.to((NaturalLanguageUsageBo)naturalLanguageUsageBo);
        Assert.assertEquals((Object)def, (Object)def2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findNaturalLanguageUsagesByName_null_fail() {
        this.service.findNaturalLanguageUsagesByName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findNaturalLanguageUsagesByDescription_null_fail() {
        this.service.findNaturalLanguageUsagesByDescription(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findNaturalLanguageUsagesByNamespace_null_fail() {
        this.service.findNaturalLanguageUsagesByNamespace(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createNaturalLanguageUsage_null_fail() {
        this.service.createNaturalLanguageUsage(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateNaturalLanguageUsage_null_fail() {
        this.service.updateNaturalLanguageUsage(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteNaturalLanguageUsage_null_fail() {
        this.service.deleteNaturalLanguageUsage(null);
    }

    public NaturalLanguageUsage getNaturalLanguageUsage() {
        return this.naturalLanguageUsage;
    }

    public void setNaturalLanguageUsageBoServiceImpl(NaturalLanguageUsageBoServiceImpl impl) {
        this.service = impl;
    }

    public static NaturalLanguageUsageBoServiceImplGenTest create(NaturalLanguageUsageBoServiceImpl impl) {
        NaturalLanguageUsageBoServiceImplGenTest test = new NaturalLanguageUsageBoServiceImplGenTest();
        test.setNaturalLanguageUsageBoServiceImpl(impl);
        return test;
    }
}

