/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krms.impl.repository.ContextBo;

public class AgendaNamespaceValuesFinder
extends UifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues(ViewModel model) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        QueryByCriteria contextCrit = QueryByCriteria.Builder.create().build();
        QueryResults contexts = KRADServiceLocator.getDataObjectService().findMatching(ContextBo.class, contextCrit);
        QueryResults namespaceBos = KradDataServiceLocator.getDataObjectService().findMatching(NamespaceBo.class, QueryByCriteria.Builder.create().build());
        HashMap<String, String> namespaceCodeToName = new HashMap<String, String>();
        if (!namespaceBos.getResults().isEmpty()) {
            for (NamespaceBo namespaceBo : namespaceBos.getResults()) {
                namespaceCodeToName.put(namespaceBo.getCode(), namespaceBo.getName());
            }
        }
        ArrayList<String> namespaceCodes = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)contexts.getResults())) {
            for (ContextBo context : contexts.getResults()) {
                if (namespaceCodes.contains(context.getNamespace())) continue;
                namespaceCodes.add(context.getNamespace());
            }
        }
        Collections.sort(namespaceCodes);
        Iterator i$ = namespaceCodes.iterator();
        while (i$.hasNext()) {
            String namespaceCode;
            String namespaceName = namespaceCode = (String)i$.next();
            if (namespaceCodeToName.containsKey(namespaceCode)) {
                namespaceName = (String)namespaceCodeToName.get(namespaceCode);
            }
            keyValues.add((KeyValue)new ConcreteKeyValue(namespaceCode, namespaceName));
        }
        return keyValues;
    }
}

