/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinitionContract;
import org.kuali.rice.krms.api.repository.term.TermParameterDefinition;
import org.kuali.rice.krms.impl.repository.TermParameterBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;

@Entity
@Table(name="KRMS_TERM_T")
public class TermBo
implements TermDefinitionContract,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1L;
    public static final String TERM_SEQ_NAME = "KRMS_TERM_S";
    @PortableSequenceGenerator(name="KRMS_TERM_S")
    @GeneratedValue(generator="KRMS_TERM_S")
    @Id
    @Column(name="TERM_ID")
    private String id;
    @Column(name="TERM_SPEC_ID")
    private String specificationId;
    @Column(name="DESC_TXT")
    private String description;
    @Version
    @Column(name="VER_NBR", length=8)
    protected Long versionNumber;
    @ManyToOne(targetEntity=TermSpecificationBo.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="TERM_SPEC_ID", referencedColumnName="TERM_SPEC_ID", insertable=false, updatable=false)
    private TermSpecificationBo specification = new TermSpecificationBo();
    @OneToMany(targetEntity=TermParameterBo.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.PERSIST}, mappedBy="term")
    private List<TermParameterBo> parameters;
    @Transient
    private Map<String, String> parametersMap = new HashMap<String, String>();
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    public static TermDefinition to(TermBo bo) {
        if (bo == null) {
            return null;
        }
        return TermDefinition.Builder.create((TermDefinitionContract)bo).build();
    }

    public static TermBo from(TermDefinition im) {
        if (im == null) {
            return null;
        }
        TermBo bo = new TermBo();
        bo._persistence_set_id(im.getId());
        bo._persistence_set_specificationId(im.getSpecification().getId());
        bo._persistence_set_description(im.getDescription());
        bo._persistence_set_specification(TermSpecificationBo.from(im.getSpecification()));
        bo._persistence_set_parameters(new ArrayList());
        for (TermParameterDefinition parm : im.getParameters()) {
            TermParameterBo termParmBo = TermParameterBo.from(parm);
            bo._persistence_get_parameters().add(termParmBo);
            termParmBo.setTerm(bo);
        }
        bo._persistence_set_versionNumber(im.getVersionNumber());
        return bo;
    }

    public TermSpecificationBo getSpecification() {
        return this._persistence_get_specification();
    }

    public void setSpecification(TermSpecificationBo specification) {
        this._persistence_set_specification(specification);
    }

    public List<TermParameterBo> getParameters() {
        return this._persistence_get_parameters();
    }

    public Map<String, String> getParametersMap() {
        return this.parametersMap;
    }

    public void setParameters(List<TermParameterBo> parameters) {
        this._persistence_set_parameters(parameters);
    }

    public void exportToParametersMap() {
        if (this._persistence_get_parameters() != null) {
            for (TermParameterBo param : this._persistence_get_parameters()) {
                this.parametersMap.put(param.getName(), param.getValue());
            }
        }
    }

    public void importFromParametersMap() {
        if (this._persistence_get_parameters() == null) {
            this._persistence_set_parameters(new ArrayList());
        } else {
            if (this.parametersMap == null || this.parametersMap.isEmpty()) {
                for (TermParameterBo termParameterBo : this._persistence_get_parameters()) {
                    this.parametersMap.put(termParameterBo.getName(), termParameterBo.getValue());
                }
            }
            this._persistence_get_parameters().clear();
        }
        for (Map.Entry entry : this.parametersMap.entrySet()) {
            TermParameterDefinition termDef = TermParameterDefinition.Builder.create(null, (String)this._persistence_get_id(), (String)((String)entry.getKey()), (String)((String)entry.getValue())).build();
            this._persistence_get_parameters().add(TermParameterBo.from(termDef));
        }
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getSpecificationId() {
        return this._persistence_get_specificationId();
    }

    public void setSpecificationId(String specificationId) {
        this._persistence_set_specificationId(specificationId);
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TermBo();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "specificationId") {
            return this.specificationId;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "specification") {
            return this.specification;
        }
        if (string == "parameters") {
            return this.parameters;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "specificationId") {
            this.specificationId = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "specification") {
            this.specification = (TermSpecificationBo)object;
            return;
        }
        if (string == "parameters") {
            this.parameters = (List)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_specificationId() {
        this._persistence_checkFetched("specificationId");
        return this.specificationId;
    }

    public void _persistence_set_specificationId(String string) {
        this._persistence_checkFetchedForSet("specificationId");
        this._persistence_propertyChange("specificationId", this.specificationId, string);
        this.specificationId = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public TermSpecificationBo _persistence_get_specification() {
        this._persistence_checkFetched("specification");
        return this.specification;
    }

    public void _persistence_set_specification(TermSpecificationBo termSpecificationBo) {
        this._persistence_checkFetchedForSet("specification");
        this._persistence_propertyChange("specification", this.specification, termSpecificationBo);
        this.specification = termSpecificationBo;
    }

    public List _persistence_get_parameters() {
        this._persistence_checkFetched("parameters");
        return this.parameters;
    }

    public void _persistence_set_parameters(List list) {
        this._persistence_checkFetchedForSet("parameters");
        this._persistence_propertyChange("parameters", this.parameters, list);
        this.parameters = list;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this._persistence_propertyChange("versionNumber", this.versionNumber, l);
        this.versionNumber = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

