/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;

public class KRMSConfigurer
extends ModuleConfigurer {
    public static final String KRMS_DATASOURCE_OBJ = "krms.datasource";
    private static final String KRMS_SPRING_LOCAL_BEANS_PATH = "classpath:org/kuali/rice/krms/config/KRMSLocalSpringBeans.xml";
    private static final String KRMS_SPRING_REMOTE_BEANS_PATH = "classpath:org/kuali/rice/krms/config/KRMSRemoteSpringBeans.xml";
    private DataSource dataSource;

    public KRMSConfigurer() {
        super("krms");
        this.setValidRunModes(Arrays.asList(RunMode.REMOTE, RunMode.LOCAL));
    }

    public void addAdditonalToConfig() {
        this.configureDataSource();
    }

    private void configureDataSource() {
        if (this.getDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject(KRMS_DATASOURCE_OBJ, (Object)this.getDataSource());
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public List<String> getPrimarySpringFiles() {
        this.LOG.info((Object)("KRMSConfigurer:getPrimarySpringFiles: getRunMode => " + this.getRunMode()));
        ArrayList<String> springFileLocations = new ArrayList<String>();
        if (RunMode.REMOTE == this.getRunMode()) {
            springFileLocations.add(KRMS_SPRING_REMOTE_BEANS_PATH);
        } else if (RunMode.LOCAL == this.getRunMode()) {
            springFileLocations.add(KRMS_SPRING_LOCAL_BEANS_PATH);
        }
        return springFileLocations;
    }
}

