/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.Map;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.impl.cache.DistributedCacheManagerDecorator;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krms.impl.repository.ContextAttributeBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;

public class ContextMaintainable
extends MaintainableImpl {
    private static final RepositoryBoIncrementer contextIdIncrementer = new RepositoryBoIncrementer("KRMS_CNTXT_S");

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        ContextBo newContext = (ContextBo)document.getNewMaintainableObject().getDataObject();
        newContext.setId(contextIdIncrementer.getNewId());
        super.processAfterNew(document, requestParameters);
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        ContextBo context = (ContextBo)document.getNewMaintainableObject().getDataObject();
        if (context.getId() == null) {
            context.setId(contextIdIncrementer.getNewId());
        }
        if (context.getName() == null) {
            context.setName(" Copy " + System.currentTimeMillis());
        }
        context.setAgendas(null);
        for (ContextAttributeBo attributeBo : context.getAttributeBos()) {
            attributeBo.setId(null);
            attributeBo.setVersionNumber(null);
        }
        super.processAfterCopy(document, requestParameters);
    }

    public void saveDataObject() {
        super.saveDataObject();
        DistributedCacheManagerDecorator distributedCacheManagerDecorator = (DistributedCacheManagerDecorator)GlobalResourceLoader.getService((String)"krmsDistributedCacheManager");
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/ContextDefinitionType").clear();
    }

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        ContextBo contextBo = (ContextBo)super.retrieveObjectForEditOrCopy(document, dataObjectKeys);
        if ("Copy".equals(this.getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Context Document");
        }
        return contextBo;
    }
}

