/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.NaturalLanguageTemplateGenTest;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoServiceImpl;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NaturalLanguageTemplateBoServiceImplGenTest {
    private NaturalLanguageTemplateBoServiceImpl naturalLanguageTemplateBoServiceImpl;
    private NaturalLanguageTemplate naturalLanguageTemplate;
    private KrmsAttributeDefinitionService krmsAttributeDefinitionService;

    NaturalLanguageTemplate getNaturalLanguageTemplate() {
        return this.naturalLanguageTemplate;
    }

    public void setNaturalLanguageTemplateBoServiceImpl(NaturalLanguageTemplateBoServiceImpl impl) {
        this.naturalLanguageTemplateBoServiceImpl = impl;
    }

    public void setKrmsAttributeDefinitionService(KrmsAttributeDefinitionService impl) {
        this.krmsAttributeDefinitionService = impl;
    }

    public static NaturalLanguageTemplateBoServiceImplGenTest create(NaturalLanguageTemplateBoServiceImpl nlTemplateBoService, KrmsAttributeDefinitionService attributeDefService) {
        NaturalLanguageTemplateBoServiceImplGenTest test = new NaturalLanguageTemplateBoServiceImplGenTest();
        test.setKrmsAttributeDefinitionService(attributeDefService);
        test.setNaturalLanguageTemplateBoServiceImpl(nlTemplateBoService);
        return test;
    }

    @Before
    public void setUp() {
        this.naturalLanguageTemplateBoServiceImpl = new NaturalLanguageTemplateBoServiceImpl();
        KrmsAttributeDefinitionService mockAttributeService = (KrmsAttributeDefinitionService)Mockito.mock(KrmsAttributeDefinitionService.class);
        NaturalLanguageTemplateBo.setAttributeDefinitionService((KrmsAttributeDefinitionService)mockAttributeService);
        KrmsTypeRepositoryService mockTypeRepositoryService = (KrmsTypeRepositoryService)Mockito.mock(KrmsTypeRepositoryService.class);
        NaturalLanguageTemplateBo.setTypeRepositoryService((KrmsTypeRepositoryService)mockTypeRepositoryService);
        this.naturalLanguageTemplateBoServiceImpl.setAttributeDefinitionService(mockAttributeService);
        this.naturalLanguageTemplateBoServiceImpl.setDataObjectService((DataObjectService)Mockito.mock(DataObjectService.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByAttributes_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.findNaturalLanguageTemplatesByAttributes(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByLanguageCode_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.findNaturalLanguageTemplatesByLanguageCode(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByNaturalLanguageUsage_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.findNaturalLanguageTemplatesByNaturalLanguageUsage(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByType_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.findNaturalLanguageTemplatesByType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByTemplate_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.findNaturalLanguageTemplatesByTemplate(null);
    }

    @Test
    public void test_from_null_yields_null() {
        assert (this.naturalLanguageTemplateBoServiceImpl.from(null) == null);
    }

    @Test
    public void test_from() {
        NaturalLanguageTemplate def = NaturalLanguageTemplateGenTest.buildFullNaturalLanguageTemplate();
        NaturalLanguageTemplateBo naturalLanguageTemplateBo = this.naturalLanguageTemplateBoServiceImpl.from(def);
        assert (naturalLanguageTemplateBo.getLanguageCode().equals(def.getLanguageCode()));
        assert (naturalLanguageTemplateBo.getNaturalLanguageUsageId().equals(def.getNaturalLanguageUsageId()));
        assert (naturalLanguageTemplateBo.getTypeId().equals(def.getTypeId()));
        assert (naturalLanguageTemplateBo.getTemplate().equals(def.getTemplate()));
        assert (naturalLanguageTemplateBo.getId().equals(def.getId()));
    }

    @Test
    public void test_to() {
        NaturalLanguageTemplate def = NaturalLanguageTemplateGenTest.buildFullNaturalLanguageTemplate();
        NaturalLanguageTemplateBo naturalLanguageTemplateBo = this.naturalLanguageTemplateBoServiceImpl.from(def);
        NaturalLanguageTemplate def2 = NaturalLanguageTemplateBo.to((NaturalLanguageTemplateBo)naturalLanguageTemplateBo);
        assert (def.equals((Object)def2));
    }

    @Test
    public void test_createNaturalLanguageTemplate() {
        NaturalLanguageTemplate def = NaturalLanguageTemplateGenTest.buildFullNaturalLanguageTemplate();
        this.naturalLanguageTemplate = this.naturalLanguageTemplateBoServiceImpl.createNaturalLanguageTemplate(def);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createNaturalLanguageTemplate_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.createNaturalLanguageTemplate(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateNaturalLanguageTemplate_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.updateNaturalLanguageTemplate(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteNaturalLanguageTemplate_null_fail() {
        this.naturalLanguageTemplateBoServiceImpl.deleteNaturalLanguageTemplate(null);
    }

    void createNaturalLanguageTemplate(NaturalLanguageUsage naturalLanguageUsage, KrmsTypeDefinition type) {
        NaturalLanguageTemplate def = NaturalLanguageTemplateGenTest.buildFullNaturalLanguageTemplate((NaturalLanguageUsage)naturalLanguageUsage, (KrmsTypeDefinition)type);
        for (Map.Entry attributeEntry : def.getAttributes().entrySet()) {
            KrmsAttributeDefinition attrDef = this.krmsAttributeDefinitionService.getAttributeDefinitionByNameAndNamespace((String)attributeEntry.getKey(), type.getNamespace());
            KrmsAttributeDefinition.Builder attrDefBuilder = KrmsAttributeDefinition.Builder.create(null, (String)((String)attributeEntry.getKey()), (String)type.getNamespace());
            this.krmsAttributeDefinitionService.createAttributeDefinition(attrDefBuilder.build());
        }
        this.naturalLanguageTemplate = this.naturalLanguageTemplateBoServiceImpl.createNaturalLanguageTemplate(def);
    }
}

