/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.HttpParams;
import org.kuali.rice.core.api.util.ClassLoaderUtils;

public class HttpClientHelper {
    private static final Map<String, Class<?>> PARAM_TYPE_MAP = new HashMap();

    public static void setParameter(HttpParams params, String paramName, String paramValue) {
        Class paramType = HttpClientHelper.getParameterType(paramName);
        if (paramType.equals(Boolean.class)) {
            params.setBooleanParameter(paramName, Boolean.parseBoolean(paramValue));
        } else if (paramType.equals(Integer.class)) {
            params.setIntParameter(paramName, Integer.parseInt(paramValue));
        } else if (paramType.equals(Long.class)) {
            params.setLongParameter(paramName, Long.parseLong(paramValue));
        } else if (paramType.equals(Double.class)) {
            params.setDoubleParameter(paramName, Double.parseDouble(paramValue));
        } else if (paramType.equals(String.class)) {
            params.setParameter(paramName, (Object)paramValue);
        } else if (paramType.equals(Class.class)) {
            try {
                Class<?> configuredClass = Class.forName(paramValue, true, ClassLoaderUtils.getDefaultClassLoader());
                params.setParameter(paramName, configuredClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not locate the class needed to configure the HttpClient.", e);
            }
        } else {
            throw new RuntimeException("Attempted to configure an HttpClient parameter '" + paramName + "' " + "of a type not supported through Workflow configuration: " + paramType.getName());
        }
    }

    public static Class getParameterType(String parameterName) {
        Class<Object> parameterType = PARAM_TYPE_MAP.get(parameterName);
        if (parameterType == null) {
            parameterType = String.class;
        }
        return parameterType;
    }

    static {
        PARAM_TYPE_MAP.put("http.protocol.version", HttpVersion.class);
        PARAM_TYPE_MAP.put("http.protocol.unambiguous-statusline", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.single-cookie-header", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.strict-transfer-encoding", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.reject-head-body", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.head-body-timeout", Integer.class);
        PARAM_TYPE_MAP.put("http.protocol.expect-continue", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.warn-extra-input", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.status-line-garbage-limit", Integer.class);
        PARAM_TYPE_MAP.put("http.socket.timeout", Integer.class);
        PARAM_TYPE_MAP.put("http.method.retry-handler", HttpMethodRetryHandler.class);
        PARAM_TYPE_MAP.put("http.dateparser.patterns", Collection.class);
        PARAM_TYPE_MAP.put("http.method.response.buffer.warnlimit", Integer.class);
        PARAM_TYPE_MAP.put("http.socket.timeout", Integer.class);
        PARAM_TYPE_MAP.put("http.tcp.nodelay", Boolean.class);
        PARAM_TYPE_MAP.put("http.socket.sendbuffer", Integer.class);
        PARAM_TYPE_MAP.put("http.socket.receivebuffer", Integer.class);
        PARAM_TYPE_MAP.put("http.socket.linger", Integer.class);
        PARAM_TYPE_MAP.put("http.connection.timeout", Integer.class);
        PARAM_TYPE_MAP.put("http.connection.stalecheck", Boolean.class);
        PARAM_TYPE_MAP.put("http.connection-manager.max-per-host", Map.class);
        PARAM_TYPE_MAP.put("http.connection-manager.max-total", Integer.class);
        PARAM_TYPE_MAP.put("http.default-headers", Collection.class);
        PARAM_TYPE_MAP.put("http.connection-manager.timeout", Long.class);
        PARAM_TYPE_MAP.put("http.connection-manager.class", Class.class);
        PARAM_TYPE_MAP.put("http.authentication.preemptive", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.reject-relative-redirect", Boolean.class);
        PARAM_TYPE_MAP.put("http.protocol.max-redirects", Integer.class);
        PARAM_TYPE_MAP.put("http.protocol.allow-circular-redirects", Boolean.class);
    }
}

