/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.bam.service.impl;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMParam;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.bam.dao.BAMDAO;
import org.kuali.rice.ksb.messaging.bam.service.BAMService;

public class BAMServiceImpl
implements BAMService {
    private static final Logger LOG = Logger.getLogger(BAMServiceImpl.class);
    private BAMDAO dao;

    @Override
    public BAMTargetEntry recordClientInvocation(ServiceConfiguration serviceConfiguration, Object target, Method method, Object[] params) {
        if (this.isEnabled()) {
            try {
                LOG.debug((Object)("A call was received... for service: " + serviceConfiguration.getServiceName().toString() + " method: " + method.getName()));
                BAMTargetEntry bamTargetEntry = this.getBAMTargetEntry(Boolean.FALSE, serviceConfiguration, target, method, params);
                this.dao.save(bamTargetEntry);
                return bamTargetEntry;
            }
            catch (Throwable t) {
                LOG.error((Object)"BAM Failed to record client invocation", t);
                return null;
            }
        }
        return null;
    }

    @Override
    public BAMTargetEntry recordServerInvocation(Object target, ServiceDefinition serviceDefinition, Method method, Object[] params) {
        if (this.isEnabled()) {
            try {
                LOG.debug((Object)("A call was received... for service: " + target.getClass().getName() + " method: " + method.getName()));
                BAMTargetEntry bamTargetEntry = this.getBAMTargetEntry(Boolean.TRUE, serviceDefinition, target, method, params);
                this.dao.save(bamTargetEntry);
                return bamTargetEntry;
            }
            catch (Throwable t) {
                LOG.error((Object)"BAM Failed to record server invocation", t);
            }
        }
        return null;
    }

    @Override
    public BAMTargetEntry recordClientInvocationError(Throwable throwable, BAMTargetEntry bamTargetEntry) {
        if (bamTargetEntry != null) {
            try {
                this.setThrowableOnBAMTargetEntry(throwable, bamTargetEntry);
                this.dao.save(bamTargetEntry);
                return bamTargetEntry;
            }
            catch (Exception e) {
                LOG.error((Object)"BAM Failed to record client invocation error", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public BAMTargetEntry recordServerInvocationError(Throwable throwable, BAMTargetEntry bamTargetEntry) {
        if (bamTargetEntry != null) {
            try {
                this.setThrowableOnBAMTargetEntry(throwable, bamTargetEntry);
                this.dao.save(bamTargetEntry);
                return bamTargetEntry;
            }
            catch (Exception e) {
                LOG.error((Object)"BAM Failed to record service invocation error", (Throwable)e);
            }
        }
        return null;
    }

    private void setThrowableOnBAMTargetEntry(Throwable throwable, BAMTargetEntry bamTargetEntry) {
        if (throwable != null) {
            bamTargetEntry.setExceptionMessage(throwable.getMessage());
            bamTargetEntry.setExceptionToString(this.makeStringfit(throwable.toString()));
        }
    }

    private BAMTargetEntry getBAMTargetEntry(Boolean serverInd, ServiceConfiguration serviceConfiguration, Object target, Method method, Object[] params) {
        BAMTargetEntry bamEntry = new BAMTargetEntry();
        bamEntry.setServerInvocation(serverInd);
        bamEntry.setServiceName(serviceConfiguration.getServiceName().toString());
        bamEntry.setServiceURL(serviceConfiguration.getEndpointUrl().toExternalForm());
        bamEntry.setTargetToString(this.makeStringfit(target.toString()));
        bamEntry.setMethodName(method.getName());
        bamEntry.setThreadName(Thread.currentThread().getName());
        bamEntry.setCallDate(new Timestamp(System.currentTimeMillis()));
        this.setBamParams(params, bamEntry);
        return bamEntry;
    }

    private BAMTargetEntry getBAMTargetEntry(Boolean serverInd, ServiceDefinition serviceDefinition, Object target, Method method, Object[] params) {
        BAMTargetEntry bamEntry = new BAMTargetEntry();
        bamEntry.setServerInvocation(serverInd);
        bamEntry.setServiceName(serviceDefinition.getServiceName().toString());
        bamEntry.setServiceURL(serviceDefinition.getEndpointUrl().toExternalForm());
        bamEntry.setTargetToString(this.makeStringfit(target.toString()));
        bamEntry.setMethodName(method.getName());
        bamEntry.setThreadName(Thread.currentThread().getName());
        bamEntry.setCallDate(new Timestamp(System.currentTimeMillis()));
        this.setBamParams(params, bamEntry);
        return bamEntry;
    }

    private void setBamParams(Object[] params, BAMTargetEntry bamEntry) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            BAMParam bamParam = new BAMParam();
            bamParam.setBamTargetEntry(bamEntry);
            bamParam.setParam(params[i].toString());
            bamEntry.addBamParam(bamParam);
        }
    }

    private String makeStringfit(String string) {
        if (string.length() > 1999) {
            return string.substring(0, 1999);
        }
        return string;
    }

    public boolean isEnabled() {
        return Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("bam.enabled"));
    }

    public BAMDAO getDao() {
        return this.dao;
    }

    public void setDao(BAMDAO dao) {
        this.dao = dao;
    }

    @Override
    public List<BAMTargetEntry> getCallsForService(QName serviceName) {
        return this.getDao().getCallsForService(serviceName);
    }

    @Override
    public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef) {
        return this.getDao().getCallsForRemotedClasses(objDef);
    }

    @Override
    public void clearBAMTables() {
        this.getDao().clearBAMTables();
    }

    @Override
    public List<BAMTargetEntry> getCallsForService(QName serviceName, String methodName) {
        return this.getDao().getCallsForService(serviceName, methodName);
    }

    @Override
    public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef, String methodName) {
        return this.getDao().getCallsForRemotedClasses(objDef, methodName);
    }
}

