/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.cxf.interceptors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.impl.cxf.interceptors.ServiceCallVersioningOutInterceptor;

public class ServiceCallVersioningHelper {
    private static final Logger LOG = Logger.getLogger(ServiceCallVersioningOutInterceptor.class);
    public static final String KUALI_RICE_ENVIRONMENT_HEADER = "X-Kuali-Env";
    public static final String KUALI_RICE_VERSION_HEADER = "X-Kuali-Rice-Ver";
    public static final String KUALI_APP_NAME_HEADER = "X-Kuali-App-Name";
    public static final String KUALI_APP_VERSION_HEADER = "X-Kuali-App-Ver";

    private ServiceCallVersioningHelper() {
    }

    public static void populateVersionHeaders(Map<String, List<String>> headers) {
        String appVersion;
        String appName;
        Config config = ConfigContext.getCurrentContextConfig();
        if (config == null) {
            LOG.error((Object)"No configuration context found when handling outbound message");
            return;
        }
        String riceEnvironment = config.getEnvironment();
        assert (StringUtils.isNotBlank((String)riceEnvironment)) : "Rice environment should never be blank";
        if (StringUtils.isNotBlank((String)riceEnvironment)) {
            headers.put(KUALI_RICE_ENVIRONMENT_HEADER, Collections.singletonList(riceEnvironment));
        }
        String riceVersion = config.getRiceVersion();
        assert (StringUtils.isNotBlank((String)riceVersion)) : "Rice version should never be blank";
        if (StringUtils.isNotBlank((String)riceVersion)) {
            headers.put(KUALI_RICE_VERSION_HEADER, Collections.singletonList(riceVersion));
        }
        if (StringUtils.isNotBlank((String)(appName = config.getApplicationName()))) {
            headers.put(KUALI_APP_NAME_HEADER, Collections.singletonList(appName));
        }
        if (StringUtils.isNotBlank((String)(appVersion = config.getApplicationVersion()))) {
            headers.put(KUALI_APP_VERSION_HEADER, Collections.singletonList(appVersion));
        }
    }
}

