/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;

public class KSBClientProxy
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(KSBClientProxy.class);
    private QName serviceName;
    private volatile Object service;

    public static <T> T newInstance(String serviceQName, Class<T> interfaceClass) throws InstantiationException, IllegalAccessException {
        if (StringUtils.isBlank((String)serviceQName)) {
            throw new IllegalArgumentException("the qname was blank");
        }
        if (interfaceClass == null) {
            throw new IllegalArgumentException("the interfaceClass was null");
        }
        Object t = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new KSBClientProxy(serviceQName));
        return (T)t;
    }

    public KSBClientProxy(String serviceQName) {
        if (StringUtils.isBlank((String)serviceQName)) {
            throw new IllegalArgumentException("the qname was blank");
        }
        this.serviceName = QName.valueOf(serviceQName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object s = this.service;
        if (s == null) {
            KSBClientProxy kSBClientProxy = this;
            synchronized (kSBClientProxy) {
                s = this.service;
                if (s == null) {
                    this.service = s = GlobalResourceLoader.getService((QName)this.serviceName);
                }
            }
        }
        if (s != null) {
            try {
                return method.invoke(s, args);
            }
            catch (InvocationTargetException e) {
                throw ExceptionUtils.getRootCause((Throwable)e);
            }
        }
        LOG.warn((Object)("serviceName: " + this.serviceName + " was not found"));
        return null;
    }
}

