/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.net.URL;
import java.util.HashMap;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.SoapServiceConfiguration;
import org.kuali.rice.ksb.impl.cxf.interceptors.ImmutableCollectionsInInterceptor;
import org.kuali.rice.ksb.messaging.serviceconnectors.AbstractServiceConnector;
import org.kuali.rice.ksb.messaging.servicehandlers.BasicAuthenticationPasswordHandler;
import org.kuali.rice.ksb.security.soap.CXFWSS4JInInterceptor;
import org.kuali.rice.ksb.security.soap.CXFWSS4JOutInterceptor;
import org.kuali.rice.ksb.security.soap.CredentialsOutHandler;
import org.kuali.rice.ksb.service.BasicAuthenticationConnectionCredentials;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class SOAPConnector
extends AbstractServiceConnector {
    private static final Logger LOG = Logger.getLogger(SOAPConnector.class);

    public SOAPConnector(SoapServiceConfiguration serviceConfiguration, URL alternateEndpointUrl) {
        super((ServiceConfiguration)serviceConfiguration, alternateEndpointUrl);
    }

    public SoapServiceConfiguration getServiceConfiguration() {
        return (SoapServiceConfiguration)super.getServiceConfiguration();
    }

    @Override
    public Object getService() {
        BasicAuthenticationConnectionCredentials credentials;
        SoapServiceConfiguration soapServiceConfiguration;
        JaxWsProxyFactoryBean clientFactory;
        if (this.getServiceConfiguration().isJaxWsService()) {
            clientFactory = new JaxWsProxyFactoryBean();
        } else {
            clientFactory = new ClientProxyFactoryBean();
            clientFactory.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
        }
        try {
            clientFactory.setServiceClass(Class.forName(this.getServiceConfiguration().getServiceInterface()));
        }
        catch (ClassNotFoundException e) {
            throw new RiceRuntimeException("Failed to connect to soap service " + this.getServiceConfiguration().getServiceName() + " because failed to load interface class: " + this.getServiceConfiguration().getServiceInterface(), (Throwable)e);
        }
        clientFactory.setBus(KSBServiceLocator.getCXFBus());
        clientFactory.setServiceName(this.getServiceConfiguration().getServiceName());
        clientFactory.setAddress(this.getActualEndpointUrl().toExternalForm());
        clientFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        clientFactory.getOutFaultInterceptors().add(new LoggingOutInterceptor());
        CXFWSS4JOutInterceptor outSecurityInterceptor = new CXFWSS4JOutInterceptor(this.getServiceConfiguration().getBusSecurity());
        clientFactory.getOutInterceptors().add(outSecurityInterceptor);
        clientFactory.getOutFaultInterceptors().add(outSecurityInterceptor);
        if (this.getCredentialsSource() != null) {
            clientFactory.getOutInterceptors().add(new CredentialsOutHandler(this.getCredentialsSource(), (ServiceConfiguration)this.getServiceConfiguration()));
        }
        if ((soapServiceConfiguration = this.getServiceConfiguration()).isBasicAuthentication().booleanValue() && (credentials = KSBServiceLocator.getBasicAuthenticationService().getConnectionCredentials(soapServiceConfiguration.getServiceName().getNamespaceURI(), soapServiceConfiguration.getServiceName().getLocalPart())) != null) {
            HashMap<String, Object> outProps = new HashMap<String, Object>();
            outProps.put("action", "UsernameToken");
            outProps.put("user", credentials.getUsername());
            outProps.put("passwordType", "PasswordText");
            outProps.put("passwordCallbackRef", new BasicAuthenticationPasswordHandler(credentials.getPassword()));
            WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(outProps);
            clientFactory.getOutInterceptors().add(wssOut);
            clientFactory.getOutFaultInterceptors().add(wssOut);
        }
        clientFactory.getInInterceptors().add(new LoggingInInterceptor());
        clientFactory.getInFaultInterceptors().add(new LoggingInInterceptor());
        CXFWSS4JInInterceptor inSecurityInterceptor = new CXFWSS4JInInterceptor(this.getServiceConfiguration().getBusSecurity());
        clientFactory.getInInterceptors().add(inSecurityInterceptor);
        clientFactory.getInFaultInterceptors().add(inSecurityInterceptor);
        clientFactory.getInInterceptors().add(new ImmutableCollectionsInInterceptor());
        Object service = clientFactory.create();
        return this.getServiceProxyWithFailureMode(service, (ServiceConfiguration)this.getServiceConfiguration());
    }
}

