/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.threadpool;

import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.messaging.threadpool.KSBThreadPool;
import org.kuali.rice.ksb.messaging.threadpool.PriorityBlockingQueuePersistedMessageComparator;

public class KSBThreadPoolImpl
extends ThreadPoolExecutor
implements KSBThreadPool {
    private static final Logger LOG = Logger.getLogger(KSBThreadPoolImpl.class);
    public static final int DEFAULT_POOL_SIZE = 5;
    private boolean started;
    private boolean poolSizeSet;

    public KSBThreadPoolImpl() {
        super(5, 5, 60L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(1, new PriorityBlockingQueuePersistedMessageComparator()), new KSBThreadFactory(ClassLoaderUtils.getDefaultClassLoader()), new ThreadPoolExecutor.AbortPolicy());
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        LOG.info((Object)("Setting core pool size to " + corePoolSize + " threads."));
        super.setCorePoolSize(corePoolSize);
        this.poolSizeSet = true;
    }

    @Override
    public long getKeepAliveTime() {
        return super.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        LOG.info((Object)"Starting the KSB thread pool...");
        this.loadSettings();
        this.started = true;
        LOG.info((Object)"...KSB thread pool successfully started.");
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            LOG.info((Object)"Shutting down KSB thread pool...");
            int pendingTasks = this.shutdownNow().size();
            LOG.info((Object)(pendingTasks + " pending tasks..."));
            LOG.info((Object)("awaiting termination: " + this.awaitTermination(20L, TimeUnit.SECONDS)));
            LOG.info((Object)("...KSB thread pool successfully stopped, isShutdown=" + this.isShutdown() + ", isTerminated=" + this.isTerminated()));
            this.started = false;
            LOG.info((Object)"...KSB thread pool successfully shut down.");
        }
    }

    protected void loadSettings() {
        String threadPoolSizeStr = ConfigContext.getCurrentContextConfig().getProperty("threadPool.size");
        if (!this.poolSizeSet) {
            int poolSize = 5;
            try {
                poolSize = new Integer(threadPoolSizeStr);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)("loadSettings(): Unable to parse the pool size: '" + threadPoolSizeStr + "'"));
            }
            this.setCorePoolSize(poolSize);
        }
    }

    @Override
    public Object getInstance() {
        return this;
    }

    private static class KSBThreadFactory
    implements ThreadFactory {
        private static int factorySequence = 0;
        private static int threadSequence = 0;
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        private ClassLoader contextClassLoader;

        public KSBThreadFactory(ClassLoader contextClassLoader) {
            this.contextClassLoader = contextClassLoader;
            ++factorySequence;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultThreadFactory.newThread(runnable);
            thread.setContextClassLoader(this.contextClassLoader);
            thread.setName(CoreConfigHelper.getApplicationId() + "/KSB-pool-" + factorySequence + "-thread-" + ++threadSequence);
            return thread;
        }
    }
}

