/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.ksb.api.registry.RemoveAndPublishResult;
import org.kuali.rice.ksb.api.registry.ServiceDescriptor;
import org.kuali.rice.ksb.api.registry.ServiceDescriptorContract;
import org.kuali.rice.ksb.api.registry.ServiceEndpoint;
import org.kuali.rice.ksb.api.registry.ServiceEndpointStatus;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.api.registry.ServiceInfoContract;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.impl.registry.ServiceDescriptorBo;
import org.kuali.rice.ksb.impl.registry.ServiceInfoBo;
import org.kuali.rice.ksb.impl.registry.ServiceRegistryDao;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private ServiceRegistryDao serviceRegistryDao;

    public List<ServiceInfo> getOnlineServicesByName(QName serviceName) throws RiceIllegalArgumentException {
        if (serviceName == null) {
            throw new RiceIllegalArgumentException("serviceName cannot be null");
        }
        List<ServiceInfoBo> serviceInfoBos = this.serviceRegistryDao.getOnlineServiceInfosByName(serviceName);
        return this.convertServiceInfoBoList(serviceInfoBos);
    }

    public List<ServiceInfo> getAllOnlineServices() {
        List<ServiceInfoBo> serviceInfoBos = this.serviceRegistryDao.getAllOnlineServiceInfos();
        return this.convertServiceInfoBoList(serviceInfoBos);
    }

    public List<ServiceInfo> getAllServices() {
        List<ServiceInfoBo> serviceInfoBos = this.serviceRegistryDao.getAllServiceInfos();
        return this.convertServiceInfoBoList(serviceInfoBos);
    }

    public List<ServiceInfo> getAllServicesForInstance(String instanceId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)instanceId)) {
            throw new RiceIllegalArgumentException("instanceId cannot be blank");
        }
        List<ServiceInfoBo> serviceInfoBos = this.serviceRegistryDao.getAllServiceInfosForInstance(instanceId);
        return this.convertServiceInfoBoList(serviceInfoBos);
    }

    public List<ServiceInfo> getAllServicesForApplication(String applicationId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)applicationId)) {
            throw new RiceIllegalArgumentException("applicationId cannot be blank");
        }
        List<ServiceInfoBo> serviceInfoBos = this.serviceRegistryDao.getAllServiceInfosForApplication(applicationId);
        return this.convertServiceInfoBoList(serviceInfoBos);
    }

    public ServiceDescriptor getServiceDescriptor(String serviceDescriptorId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)serviceDescriptorId)) {
            throw new RiceIllegalArgumentException("serviceDescriptorId cannot be blank");
        }
        ServiceDescriptorBo serviceDescriptorBo = this.serviceRegistryDao.getServiceDescriptor(serviceDescriptorId);
        return ServiceDescriptorBo.to(serviceDescriptorBo);
    }

    public List<ServiceDescriptor> getServiceDescriptors(List<String> serviceDescriptorIds) throws RiceIllegalArgumentException {
        if (serviceDescriptorIds == null) {
            throw new RiceIllegalArgumentException("serviceDescriptorIds cannot be null");
        }
        ArrayList<ServiceDescriptor> serviceDescriptors = new ArrayList<ServiceDescriptor>();
        for (String serviceDescriptorId : serviceDescriptorIds) {
            ServiceDescriptor serviceDescriptor = this.getServiceDescriptor(serviceDescriptorId);
            if (serviceDescriptor == null) continue;
            serviceDescriptors.add(serviceDescriptor);
        }
        return Collections.unmodifiableList(serviceDescriptors);
    }

    public ServiceEndpoint publishService(ServiceEndpoint serviceEndpoint) throws RiceIllegalArgumentException {
        if (serviceEndpoint == null) {
            throw new RiceIllegalArgumentException("serviceEndpoint cannot be null");
        }
        ServiceDescriptor serviceDescriptor = serviceEndpoint.getDescriptor();
        ServiceDescriptorBo serviceDescriptorBo = ServiceDescriptorBo.from(serviceDescriptor);
        ServiceInfo serviceInfo = serviceEndpoint.getInfo();
        ServiceInfoBo serviceInfoBo = ServiceInfoBo.from(serviceInfo);
        serviceDescriptorBo = this.serviceRegistryDao.saveServiceDescriptor(serviceDescriptorBo);
        serviceInfoBo.setServiceDescriptorId(serviceDescriptorBo.getId());
        this.serviceRegistryDao.saveServiceInfo(serviceInfoBo);
        return ServiceEndpoint.Builder.create((ServiceInfo.Builder)ServiceInfo.Builder.create((ServiceInfoContract)serviceInfoBo), (ServiceDescriptor.Builder)ServiceDescriptor.Builder.create((ServiceDescriptorContract)serviceDescriptorBo)).build();
    }

    public List<ServiceEndpoint> publishServices(List<ServiceEndpoint> serviceEndpoints) throws RiceIllegalArgumentException {
        if (serviceEndpoints == null) {
            throw new RiceIllegalArgumentException("serviceEndpoints cannot be null");
        }
        ArrayList<ServiceEndpoint> publishedEndpoints = new ArrayList<ServiceEndpoint>();
        for (ServiceEndpoint serviceEndpoint : serviceEndpoints) {
            publishedEndpoints.add(this.publishService(serviceEndpoint));
        }
        return publishedEndpoints;
    }

    public ServiceEndpoint removeServiceEndpoint(String serviceId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)serviceId)) {
            throw new RiceIllegalArgumentException("serviceId cannot be blank");
        }
        ServiceInfoBo serviceInfoBo = this.serviceRegistryDao.getServiceInfo(serviceId);
        if (serviceInfoBo != null) {
            ServiceDescriptorBo serviceDescriptorBo = this.serviceRegistryDao.getServiceDescriptor(serviceInfoBo.getServiceDescriptorId());
            ServiceEndpoint endpointPriorRemoval = ServiceEndpoint.Builder.create((ServiceInfo.Builder)ServiceInfo.Builder.create((ServiceInfoContract)serviceInfoBo), (ServiceDescriptor.Builder)ServiceDescriptor.Builder.create((ServiceDescriptorContract)serviceDescriptorBo)).build();
            this.serviceRegistryDao.removeServiceInfo(serviceInfoBo.getServiceId());
            this.serviceRegistryDao.removeServiceDescriptor(serviceInfoBo.getServiceDescriptorId());
            return endpointPriorRemoval;
        }
        return null;
    }

    public List<ServiceEndpoint> removeServiceEndpoints(List<String> serviceIds) throws RiceIllegalArgumentException {
        if (serviceIds == null) {
            throw new RiceIllegalArgumentException("serviceIds canot be null");
        }
        ArrayList<ServiceEndpoint> servicesRemoved = new ArrayList<ServiceEndpoint>();
        for (String serviceId : serviceIds) {
            servicesRemoved.add(this.removeServiceEndpoint(serviceId));
        }
        return servicesRemoved;
    }

    public RemoveAndPublishResult removeAndPublish(List<String> removeServiceIds, List<ServiceEndpoint> publishServiceEndpoints) {
        List<Object> servicesRemoved = new ArrayList();
        List<Object> servicesPublished = new ArrayList();
        if (removeServiceIds != null && !removeServiceIds.isEmpty()) {
            servicesRemoved = this.removeServiceEndpoints(removeServiceIds);
        }
        if (publishServiceEndpoints != null && !publishServiceEndpoints.isEmpty()) {
            servicesPublished = this.publishServices(publishServiceEndpoints);
        }
        return RemoveAndPublishResult.create(servicesRemoved, servicesPublished);
    }

    public boolean updateStatus(String serviceId, ServiceEndpointStatus status) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)serviceId)) {
            throw new RiceIllegalArgumentException("serviceId cannot be blank");
        }
        if (status == null) {
            throw new RiceIllegalArgumentException("status cannot be null");
        }
        return this.serviceRegistryDao.updateStatus(serviceId, status.getCode());
    }

    public List<String> updateStatuses(List<String> serviceIds, ServiceEndpointStatus status) throws RiceIllegalArgumentException {
        if (serviceIds == null) {
            throw new RiceIllegalArgumentException("serviceIds canot be null");
        }
        if (status == null) {
            throw new RiceIllegalArgumentException("status cannot be null");
        }
        ArrayList<String> updatedServiceIds = new ArrayList<String>();
        for (String serviceId : serviceIds) {
            if (!this.updateStatus(serviceId, status)) continue;
            updatedServiceIds.add(serviceId);
        }
        return Collections.unmodifiableList(updatedServiceIds);
    }

    public void takeInstanceOffline(String instanceId) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)instanceId)) {
            throw new RiceIllegalArgumentException("instanceId cannot be blank");
        }
        this.serviceRegistryDao.updateStatusForInstanceId(instanceId, ServiceEndpointStatus.OFFLINE.getCode());
    }

    private List<ServiceInfo> convertServiceInfoBoList(List<ServiceInfoBo> serviceInfoBos) {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        if (serviceInfoBos != null) {
            for (ServiceInfoBo serviceInfoBo : serviceInfoBos) {
                serviceInfos.add(ServiceInfoBo.to(serviceInfoBo));
            }
        } else {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(serviceInfos);
    }

    public void setServiceRegistryDao(ServiceRegistryDao serviceRegistryDao) {
        this.serviceRegistryDao = serviceRegistryDao;
    }
}

