/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.registry;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.ksb.api.registry.ServiceRegistry;
import org.kuali.rice.ksb.impl.registry.ServiceInfoBo;
import org.kuali.rice.ksb.impl.registry.ServiceRegistryImpl;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ServiceRegistryImplTest {
    @Mock
    private DataObjectService dataObjectService;
    @InjectMocks
    private ServiceRegistryImpl serviceRegistryImpl = new ServiceRegistryImpl();
    private ServiceRegistry serviceRegistry = this.serviceRegistryImpl;
    private static int ID_VALUE = 0;

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Test(expected=RiceIllegalArgumentException.class)
    public void testGetAllServicesForInstance_Null() {
        this.serviceRegistry.getAllServicesForInstance(null);
    }

    @Test(expected=RiceIllegalArgumentException.class)
    public void testGetAllServicesForInstance_Empty() {
        this.serviceRegistry.getAllServicesForInstance("");
    }

    @Test(expected=RiceIllegalArgumentException.class)
    public void testGetAllServicesForInstance_Blank() {
        this.serviceRegistry.getAllServicesForInstance(" ");
    }

    @Test
    public void testGetAllServicesForInstance() {
        GenericQueryResults.Builder resultBuilder = GenericQueryResults.Builder.create();
        for (int i = 0; i < 5; ++i) {
            resultBuilder.getResults().add(this.createServiceInfo("service" + i));
        }
        Mockito.when((Object)this.dataObjectService.findMatching((Class)Matchers.eq(ServiceInfoBo.class), (QueryByCriteria)Matchers.any(QueryByCriteria.class))).thenReturn((Object)resultBuilder.build());
        List serviceInfos = this.serviceRegistry.getAllServicesForInstance("MyInstance");
        Assert.assertEquals((long)5L, (long)serviceInfos.size());
    }

    private String nextId() {
        return ++ID_VALUE + "";
    }

    private ServiceInfoBo createServiceInfo(String serviceName) {
        ServiceInfoBo serviceInfo = new ServiceInfoBo();
        serviceInfo.setServiceId(this.nextId());
        serviceInfo.setServiceName(serviceName);
        serviceInfo.setEndpointUrl("localhost");
        serviceInfo.setInstanceId("MyInstance");
        serviceInfo.setApplicationId(this.nextId());
        serviceInfo.setServerIpAddress("127.0.0.1");
        serviceInfo.setType("type");
        serviceInfo.setServiceVersion("1.0");
        serviceInfo.setStatusCode("A");
        serviceInfo.setServiceDescriptorId(this.nextId());
        serviceInfo.setChecksum("abcdefg");
        return serviceInfo;
    }
}

