/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.postalcode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.criteria.GenericQueryResults;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.postalcode.PostalCode;
import org.kuali.rice.location.api.postalcode.PostalCodeContract;
import org.kuali.rice.location.api.postalcode.PostalCodeQueryResults;
import org.kuali.rice.location.api.postalcode.PostalCodeService;
import org.kuali.rice.location.impl.postalcode.PostalCodeBo;

public class PostalCodeServiceImpl
implements PostalCodeService {
    private BusinessObjectService businessObjectService;
    private CriteriaLookupService criteriaLookupService;

    public PostalCode getPostalCode(String countryCode, String code) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("countryCode", countryCode);
        map.put("code", code);
        return PostalCodeBo.to((PostalCodeBo)this.businessObjectService.findByPrimaryKey(PostalCodeBo.class, Collections.unmodifiableMap(map)));
    }

    public List<PostalCode> findAllPostalCodesInCountry(String countryCode) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("countryCode", countryCode);
        map.put("active", Boolean.TRUE);
        Collection bos = this.businessObjectService.findMatching(PostalCodeBo.class, Collections.unmodifiableMap(map));
        if (bos == null) {
            return Collections.emptyList();
        }
        ArrayList<PostalCode> toReturn = new ArrayList<PostalCode>();
        for (PostalCodeBo bo : bos) {
            if (bo == null || !bo.isActive()) continue;
            toReturn.add(PostalCodeBo.to(bo));
        }
        return Collections.unmodifiableList(toReturn);
    }

    public PostalCodeQueryResults findPostalCodes(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        GenericQueryResults results = this.criteriaLookupService.lookup(PostalCodeBo.class, queryByCriteria);
        PostalCodeQueryResults.Builder builder = PostalCodeQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<PostalCode.Builder> ims = new ArrayList<PostalCode.Builder>();
        for (PostalCodeBo bo : results.getResults()) {
            ims.add(PostalCode.Builder.create((PostalCodeContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public void setCriteriaLookupService(CriteriaLookupService criteriaLookupService) {
        this.criteriaLookupService = criteriaLookupService;
    }
}

