/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.bookstore.document.web;

import edu.sampleu.bookstore.bo.Book;
import edu.sampleu.bookstore.bo.BookOrder;
import edu.sampleu.bookstore.document.BookOrderDocument;
import edu.sampleu.bookstore.document.web.BookOrderForm;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kns.web.struts.action.KualiTransactionalDocumentActionBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class BookOrderAction
extends KualiTransactionalDocumentActionBase {
    public ActionForward addBookOrder(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BookOrderForm form = (BookOrderForm)actionForm;
        BookOrderDocument document = form.getBookOrderDocument();
        BookOrder newBookEntry = form.getNewBookOrder();
        document.addBookOrder(newBookEntry);
        for (BookOrder entry : document.getBookOrders()) {
            if (entry.getBookId() == null) continue;
            Book book = (Book)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(Book.class, (Object)entry.getBookId());
            entry.setUnitPrice(book.getPrice());
            Double totalPrice = 0.0;
            if (book.getPrice() != null && entry.getQuantity() != null) {
                totalPrice = book.getPrice().doubleValue() * (double)entry.getQuantity().intValue();
                if (entry.getDiscount() != null && entry.getDiscount().doubleValue() > 0.0) {
                    totalPrice = totalPrice - totalPrice * entry.getDiscount().doubleValue() / 100.0;
                }
            }
            entry.setTotalPrice(new KualiDecimal(totalPrice.doubleValue()));
        }
        form.setNewBookOrder(new BookOrder());
        return mapping.findForward("basic");
    }

    public ActionForward deleteBookOrder(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BookOrderForm form = (BookOrderForm)actionForm;
        BookOrderDocument document = form.getBookOrderDocument();
        int deleteIndex = this.getLineToDelete(request);
        document.removeBookOrder(deleteIndex);
        return mapping.findForward("basic");
    }

    protected void doProcessingAfterPost(KualiForm actionForm, HttpServletRequest request) {
        super.doProcessingAfterPost(actionForm, request);
        BookOrderForm form = (BookOrderForm)actionForm;
        BookOrderDocument document = form.getBookOrderDocument();
        for (BookOrder entry : document.getBookOrders()) {
            if (entry.getBookId() == null) continue;
            Book book = (Book)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(Book.class, (Object)entry.getBookId());
            entry.setUnitPrice(book.getPrice());
            Double totalPrice = 0.0;
            if (book.getPrice() != null && entry.getQuantity() != null) {
                totalPrice = book.getPrice().doubleValue() * (double)entry.getQuantity().intValue();
                if (entry.getDiscount() != null && entry.getDiscount().doubleValue() > 0.0) {
                    totalPrice = totalPrice - totalPrice * entry.getDiscount().doubleValue() / 100.0;
                }
            }
            entry.setTotalPrice(new KualiDecimal(totalPrice.doubleValue()));
            entry.setBook(book);
        }
    }
}

