/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.bookstore.document.attribs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jws.WebParam;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableDatepicker;
import org.kuali.rice.kew.api.document.DocumentWithContent;
import org.kuali.rice.kew.api.document.attribute.DocumentAttribute;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;
import org.kuali.rice.kew.framework.document.attribute.SearchableAttribute;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class XPathSearchableAttribute
implements SearchableAttribute {
    protected final Logger log;
    protected final String key;
    protected final String title;
    protected final String xpathExpression;
    protected final String dataType;

    protected XPathSearchableAttribute(String key, String dataType, String xpathExpression) {
        this(key, dataType, xpathExpression, null);
    }

    protected XPathSearchableAttribute(String key, String dataType, String xpathExpression, String title) {
        this.key = key;
        this.dataType = dataType;
        this.xpathExpression = xpathExpression;
        this.log = Logger.getLogger((String)(this.getClass().getName() + ":" + key));
        this.title = title == null ? this.log.getName() : title;
    }

    public String generateSearchContent(@WebParam(name="extensionDefinition") ExtensionDefinition extensionDefinition, @WebParam(name="documentTypeName") String documentTypeName, @WebParam(name="attributeDefinition") WorkflowAttributeDefinition attributeDefinition) {
        return null;
    }

    public List<DocumentAttribute> extractDocumentAttributes(@WebParam(name="extensionDefinition") ExtensionDefinition extensionDefinition, @WebParam(name="documentWithContent") DocumentWithContent documentWithContent) {
        ArrayList<DocumentAttribute> attribs = new ArrayList<DocumentAttribute>(1);
        String appContent = documentWithContent.getDocumentContent().getApplicationContent();
        XPath xpath = XPathHelper.newXPath();
        try {
            Element source = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new BufferedReader(new StringReader(appContent)))).getDocumentElement();
            String result = (String)xpath.evaluate(this.xpathExpression, source, XPathConstants.STRING);
            if (StringUtils.isNotEmpty((String)result)) {
                try {
                    attribs.add(XPathSearchableAttribute.createAttribute((String)this.key, (String)result, (String)this.dataType));
                }
                catch (ParseException pe) {
                    this.log.error((Object)("Error converting value '" + result + "' to type '" + this.dataType + "'"));
                }
            }
        }
        catch (XPathExpressionException xep) {
            this.log.error((Object)("Error evaluating searchable attribute expression: '" + this.xpathExpression + "'"), (Throwable)xep);
        }
        catch (SAXException se) {
            this.log.error((Object)("Error parsing application content: '" + appContent + "'"), (Throwable)se);
        }
        catch (ParserConfigurationException pce) {
            this.log.error((Object)("Error parsing application content: '" + appContent + "'"), (Throwable)pce);
        }
        catch (IOException ioe) {
            this.log.error((Object)("Error parsing application content: '" + appContent + "'"), (Throwable)ioe);
        }
        return attribs;
    }

    protected static DocumentAttribute createAttribute(String name, String value, String dataTypeValue) throws ParseException {
        if (StringUtils.isBlank((String)dataTypeValue)) {
            return DocumentAttributeFactory.createStringAttribute((String)name, (String)value);
        }
        if ("string".equals(dataTypeValue)) {
            return DocumentAttributeFactory.createStringAttribute((String)name, (String)value);
        }
        if ("datetime".equals(dataTypeValue)) {
            try {
                return DocumentAttributeFactory.createDateTimeAttribute((String)name, (Date)CoreApiServiceLocator.getDateTimeService().convertToDate(value));
            }
            catch (ParseException pe) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                dateFormat.setLenient(false);
                Date date = dateFormat.parse(value);
                return DocumentAttributeFactory.createDateTimeAttribute((String)name, (Date)date);
            }
        }
        if ("long".equals(dataTypeValue)) {
            return DocumentAttributeFactory.createIntegerAttribute((String)name, (BigInteger)new BigInteger(value));
        }
        if ("float".equals(dataTypeValue)) {
            return DocumentAttributeFactory.createDecimalAttribute((String)name, (BigDecimal)new BigDecimal(value));
        }
        throw new IllegalArgumentException("Invalid dataTypeValue was given: " + dataTypeValue);
    }

    public List<RemotableAttributeField> getSearchFields(@WebParam(name="extensionDefinition") ExtensionDefinition extensionDefinition, @WebParam(name="documentTypeName") String documentTypeName) {
        ArrayList<RemotableAttributeField> fields = new ArrayList<RemotableAttributeField>();
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)this.key);
        builder.setLongLabel(this.title);
        builder.setDataType(DocumentSearchInternalUtils.convertValueToDataType((String)this.dataType));
        if ("datetime".equals(this.dataType)) {
            builder.getWidgets().add(RemotableDatepicker.Builder.create());
        }
        builder = this.decorateRemotableAttributeField(builder);
        fields.add(builder.build());
        return fields;
    }

    protected RemotableAttributeField.Builder decorateRemotableAttributeField(RemotableAttributeField.Builder raf) {
        return raf;
    }

    public List<RemotableAttributeError> validateDocumentAttributeCriteria(@WebParam(name="extensionDefinition") ExtensionDefinition extensionDefinition, @WebParam(name="documentSearchCriteria") DocumentSearchCriteria documentSearchCriteria) {
        SearchableAttributeValue valueType = DocumentSearchInternalUtils.getSearchableAttributeValueByDataTypeString((String)this.dataType);
        return DocumentSearchInternalUtils.validateSearchFieldValues((String)this.key, (SearchableAttributeValue)valueType, (List)((List)documentSearchCriteria.getDocumentAttributeValues().get(this.key)), (String)this.log.getName(), null, null);
    }
}

