/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.bookstore.rule;

import edu.sampleu.bookstore.bo.BookOrder;
import edu.sampleu.bookstore.document.BookOrderDocument;
import java.util.List;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.TransactionalDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class BookOrderDocumentRule
extends TransactionalDocumentRuleBase {
    private static final String BOOK_ORDERS_PROPERTY_PATH = "document.bookOrders";
    private static final String NO_BOOK_ORDERS_ERROR_KEY = "error.custom";
    private static final String ERROR_MESSAGE_NO_ORDERS = "You must add at least one entry to your book order.";
    private static final String BOOK_ORDERS_EMPTY_ERROR_KEY = "error.custom";
    private static final String ERROR_MESSAGE_EMPTY_ORDERS = "You must add attributes to your book order.";

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        System.out.println("@@@@ IN RULE CHECK");
        BookOrderDocument bookOrderDocument = (BookOrderDocument)document;
        List bookOrders = bookOrderDocument.getBookOrders();
        if (bookOrders == null || bookOrders.isEmpty()) {
            GlobalVariables.getMessageMap().putError(BOOK_ORDERS_PROPERTY_PATH, "error.custom", new String[]{ERROR_MESSAGE_NO_ORDERS});
            System.out.println("@@@@ FALSE RULE CHECK");
            return false;
        }
        for (BookOrder bookOrder : bookOrders) {
            if (bookOrder.getBookId() != null && bookOrder.getDiscount() != null && bookOrder.getQuantity() != null) continue;
            GlobalVariables.getMessageMap().putError(BOOK_ORDERS_PROPERTY_PATH, "error.custom", new String[]{ERROR_MESSAGE_EMPTY_ORDERS});
            System.out.println("@@@@ FALSE RULE CHECK");
            return false;
        }
        System.out.println("@@@@ TRUE RULE CHECK");
        return super.processCustomRouteDocumentBusinessRules(document);
    }
}

