/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.travel.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.identity.PrincipalId;
import org.kuali.rice.kew.api.identity.PrincipalName;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.GenericRoleAttribute;
import org.kuali.rice.kew.rule.QualifiedRoleName;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;

public class EmployeeAttribute
extends GenericRoleAttribute {
    private static final RoleName EMPLOYEE_ROLE = new RoleName(EmployeeAttribute.class.getName(), "employee", "Employee");
    private static final RoleName SUPERVISOR_ROLE = new RoleName(EmployeeAttribute.class.getName(), "supervisr", "Supervisor");
    private static final RoleName DIRECTOR_ROLE = new RoleName(EmployeeAttribute.class.getName(), "director", "Dean/Director");
    private static final List<RoleName> ROLES;
    private static String USERID_FORM_FIELDNAME;
    private String traveler;

    public EmployeeAttribute() {
        super("employee");
    }

    public EmployeeAttribute(String traveler) {
        super("employee");
        this.traveler = traveler;
    }

    public void setTraveler(String traveler) {
        this.traveler = traveler;
    }

    public List<RoleName> getRoleNames() {
        return ROLES;
    }

    protected boolean isValidRole(String roleName) {
        for (RoleName role : ROLES) {
            if (!role.getBaseName().equals(roleName)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getRoleNameQualifiers(String roleName, DocumentContent documentContent) {
        if (!this.isValidRole(roleName)) {
            throw new WorkflowRuntimeException("Invalid role: " + roleName);
        }
        ArrayList<String> qualifiers = new ArrayList<String>();
        qualifiers.add(roleName);
        return qualifiers;
    }

    protected ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, QualifiedRoleName qualifiedRoleName) {
        List recipients = this.resolveRecipients(routeContext, qualifiedRoleName);
        ResolvedQualifiedRole rqr = new ResolvedQualifiedRole(this.getLabelForQualifiedRoleName(qualifiedRoleName), recipients, qualifiedRoleName.getBaseRoleName());
        return rqr;
    }

    protected List<Id> resolveRecipients(RouteContext routeContext, QualifiedRoleName qualifiedRoleName) {
        ArrayList<Id> members = new ArrayList<Id>();
        PrincipalId roleUserId = null;
        String roleName = qualifiedRoleName.getBaseRoleName();
        String roleTraveler = qualifiedRoleName.getQualifier();
        if (StringUtils.equals((String)EMPLOYEE_ROLE.getBaseName(), (String)roleName)) {
            roleUserId = new PrincipalId(roleTraveler);
        } else if (StringUtils.equals((String)SUPERVISOR_ROLE.getBaseName(), (String)roleName)) {
            roleUserId = new PrincipalName("supervisr");
        } else if (StringUtils.equals((String)DIRECTOR_ROLE.getBaseName(), (String)roleName)) {
            roleUserId = new PrincipalName("director");
        } else {
            throw new WorkflowRuntimeException("unable to process unknown role '" + roleName + "'");
        }
        members.add((Id)roleUserId);
        return members;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("traveler", this.traveler);
        return properties;
    }

    public List getFieldConversions() {
        ArrayList<ConcreteKeyValue> conversionFields = new ArrayList<ConcreteKeyValue>();
        conversionFields.add(new ConcreteKeyValue("userid", USERID_FORM_FIELDNAME));
        return conversionFields;
    }

    public List<Row> getRoutingDataRows() {
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("Traveler username", "", "text", false, USERID_FORM_FIELDNAME, "", false, false, null, null));
        rows.add(new Row(fields));
        return rows;
    }

    public List validateRoutingData(Map paramMap) {
        ArrayList<WorkflowServiceErrorImpl> errors = new ArrayList<WorkflowServiceErrorImpl>();
        String userid = StringUtils.trim((String)((String)paramMap.get(USERID_FORM_FIELDNAME)));
        if (this.isRequired() && StringUtils.isBlank((String)userid)) {
            errors.add(new WorkflowServiceErrorImpl("userid is required", "uh.accountattribute.userid.required"));
        }
        Principal principal = null;
        if (!StringUtils.isBlank((String)userid)) {
            principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(userid);
        }
        if (principal == null) {
            errors.add(new WorkflowServiceErrorImpl("unable to retrieve user for userid '" + userid + "'", "uh.accountattribute.userid.invalid"));
        }
        if (errors.size() == 0) {
            this.traveler = principal.getPrincipalId();
        }
        return errors;
    }

    static {
        ArrayList<RoleName> tmp = new ArrayList<RoleName>(1);
        tmp.add(EMPLOYEE_ROLE);
        tmp.add(SUPERVISOR_ROLE);
        tmp.add(DIRECTOR_ROLE);
        ROLES = Collections.unmodifiableList(tmp);
        USERID_FORM_FIELDNAME = "userid";
    }
}

