/*
 * Decompiled with CFR 0.152.
 */
package edu.sampleu.demo;

import edu.sampleu.demo.TestSuggestClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TestSuggestClass {
    public static List<String> getLanguages(String term) {
        ArrayList<String> matchingLanguages = new ArrayList<String>();
        String[] languageArray = new String[]{"ActionScript", "AppleScript", "Asp", "BASIC", "C", "C++", "Clojure", "COBOL", "ColdFusion", "Erlang", "Fortran", "Groovy", "Haskell", "Java", "JavaScript", "Lisp", "Perl", "PHP", "Python", "Ruby", "Scala", "Scheme"};
        for (int i = 0; i < languageArray.length; ++i) {
            String language = languageArray[i];
            if (!language.toLowerCase().startsWith(term.toLowerCase())) continue;
            matchingLanguages.add(language);
        }
        return matchingLanguages;
    }

    public static List<String> getAllLanguages() {
        String[] languageArray = new String[]{"ActionScript", "AppleScript", "Asp", "BASIC", "C", "C++", "Clojure", "COBOL", "ColdFusion", "Erlang", "Fortran", "Groovy", "Haskell", "Java", "JavaScript", "Lisp", "Perl", "PHP", "Python", "Ruby", "Scala", "Scheme"};
        return Arrays.asList(languageArray);
    }

    public static List<TestLabelValue> getRichOptions() {
        ArrayList<TestLabelValue> options = new ArrayList<TestLabelValue>();
        options.add(new TestLabelValue("r1", "<b>Rich Option 1</b><br/><i>this is a desc for option 1</i>"));
        options.add(new TestLabelValue("r1", "<b>Rich Option 2</b><br/><i>this is a desc for option 2</i>"));
        options.add(new TestLabelValue("r1", "<b>Rich Option 3</b><br/><i>this is a desc for option 3</i>"));
        return options;
    }

    public static List<TestSuggestObject> getComplexOptions() {
        ArrayList<TestSuggestObject> options = new ArrayList<TestSuggestObject>();
        options.add(new TestSuggestObject("1", "jhbon", "Bohan, Jack"));
        options.add(new TestSuggestObject("2", "jmcross", "Cross, Jeff"));
        options.add(new TestSuggestObject("3", "jomot", "Mot, Joe"));
        return options;
    }

    public static List<TestLocationObject> getLocationOptions() {
        ArrayList<TestLocationObject> options = new ArrayList<TestLocationObject>();
        options.add(new TestLocationObject(null, "Google", "http://www.google.com"));
        options.add(new TestLocationObject(null, "Kuali", "http://www.kuali.org"));
        options.add(new TestLocationObject(null, "Jira", "https://jira.kuali.org"));
        return options;
    }

    public static List<TestViewObject> getViewOptions() {
        ArrayList<TestViewObject> options = new ArrayList<TestViewObject>();
        options.add(new TestViewObject("UifCompView"));
        options.add(new TestViewObject("RichMessagesView"));
        options.add(new TestViewObject("ConfigurationTestView-Collections"));
        options.add(new TestViewObject("ConfigurationTestView"));
        return options;
    }

    public static List<TestObject> getObjectOptions(String term) {
        ArrayList<TestObject> options = new ArrayList<TestObject>();
        options.add(new TestObject("Apple", "AppleType", "aaa"));
        options.add(new TestObject("Orange", "OrangeType", "ooo"));
        options.add(new TestObject("Strawberry", "StrawberryType", "sss"));
        return options;
    }
}

