/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.sql.spring;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.common.jdbc.model.context.JdbcContext;
import org.kuali.common.jdbc.reset.DefaultJdbcResetConfig;
import org.kuali.common.jdbc.service.spring.DataSourceConfig;
import org.kuali.common.jdbc.sql.spring.DbaContextConfig;
import org.kuali.common.jdbc.sql.spring.JdbcContextsConfig;
import org.kuali.common.jdbc.suppliers.ResourcesSupplierFactory;
import org.kuali.common.jdbc.suppliers.spring.SuppliersFactoryConfig;
import org.kuali.common.jdbc.vendor.model.DatabaseVendor;
import org.kuali.common.util.metainf.model.PathComparator;
import org.kuali.common.util.metainf.service.MetaInfUtils;
import org.kuali.common.util.metainf.spring.MetaInfDataLocation;
import org.kuali.common.util.metainf.spring.MetaInfDataType;
import org.kuali.common.util.metainf.spring.MetaInfGroup;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.rice.db.config.profile.MetaInfDataLocationProfileConfig;
import org.kuali.rice.db.config.profile.MetaInfDataTypeProfileConfig;
import org.kuali.rice.db.config.profile.MetaInfFilterConfig;
import org.kuali.rice.db.config.profile.RiceClientBootstrapConfig;
import org.kuali.rice.db.config.profile.RiceClientDemoConfig;
import org.kuali.rice.db.config.profile.RiceMasterConfig;
import org.kuali.rice.db.config.profile.RiceServerBootstrapConfig;
import org.kuali.rice.db.config.profile.RiceServerDemoConfig;
import org.kuali.rice.db.config.profile.RiceServerDemoFilterConfig;
import org.kuali.rice.sql.project.SqlProjectConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DbaContextConfig.class, SuppliersFactoryConfig.class, DefaultJdbcResetConfig.class, RiceClientBootstrapConfig.class, RiceClientDemoConfig.class, RiceServerBootstrapConfig.class, RiceServerDemoConfig.class, RiceServerDemoFilterConfig.class, RiceMasterConfig.class})
public class SourceSqlConfig
implements JdbcContextsConfig {
    private static final String PATH_SEPARATOR = "/";
    private static final String INITIAL_SQL_PATH = "initial-sql/2.3.0";
    private static final String UPGRADE_SQL_PATH = "upgrades/*";
    @Autowired
    DbaContextConfig dba;
    @Autowired
    ResourcesSupplierFactory factory;
    @Autowired
    DatabaseVendor vendor;
    @Autowired
    DataSourceConfig dataSources;
    @Autowired(required=false)
    MetaInfDataLocationProfileConfig locationConfig;
    @Autowired(required=false)
    MetaInfDataTypeProfileConfig typeConfig;
    @Autowired(required=false)
    MetaInfFilterConfig serverDemoFilterConfig;

    @Bean
    public List<JdbcContext> jdbcContexts() {
        ArrayList jdbcContexts = Lists.newArrayList();
        List<MetaInfDataType> types = this.getTypes();
        List<MetaInfDataLocation> locations = this.getLocations();
        ArrayList groups = Lists.newArrayList((Object[])new MetaInfGroup[]{MetaInfGroup.SCHEMA, MetaInfGroup.DATA, MetaInfGroup.CONSTRAINTS});
        jdbcContexts.add(this.dba.dbaBeforeContext());
        for (MetaInfDataType type : types) {
            for (MetaInfDataLocation location : locations) {
                for (MetaInfGroup group : groups) {
                    jdbcContexts.add(this.getJdbcContext(group, INITIAL_SQL_PATH, this.vendor.getCode(), location, type, true));
                }
                jdbcContexts.add(this.getJdbcContext(MetaInfGroup.OTHER, UPGRADE_SQL_PATH, this.vendor.getCode(), location, type, false));
            }
        }
        jdbcContexts.add(this.dba.dbaAfterContext());
        return ImmutableList.copyOf((Collection)jdbcContexts);
    }

    protected List<MetaInfDataType> getTypes() {
        return this.typeConfig != null ? this.typeConfig.getMetaInfDataTypes() : Lists.newArrayList();
    }

    protected List<MetaInfDataLocation> getLocations() {
        return this.locationConfig != null ? this.locationConfig.getMetaInfDataLocations() : Lists.newArrayList();
    }

    protected JdbcContext getJdbcContext(MetaInfGroup group, String qualifier, String vendor, MetaInfDataLocation location, MetaInfDataType type, boolean multithreaded) {
        DataSource dataSource = this.dataSources.dataSource();
        ArrayList suppliers = Lists.newArrayList();
        PathComparator comparator = new PathComparator();
        if (this.isIncluded(group, location, type) && !this.isExcluded(group, location, type)) {
            List resources = MetaInfUtils.getPatternedClasspathResources((ProjectIdentifier)SqlProjectConstants.ID, (Optional)Optional.of((Object)(qualifier + PATH_SEPARATOR + vendor)), (Optional)Optional.of((Object)location), (Optional)Optional.of((Object)type), (String)group.name().toLowerCase());
            Collections.sort(resources, comparator);
            suppliers.addAll(this.factory.getSuppliers(resources));
        }
        String message = "[" + group.name().toLowerCase() + ":" + (multithreaded ? "concurrent" : "sequential") + "]";
        return new JdbcContext.Builder(dataSource, (List)suppliers).message(message).multithreaded(multithreaded).build();
    }

    protected boolean isIncluded(MetaInfGroup group, MetaInfDataLocation location, MetaInfDataType type) {
        return this.serverDemoFilterConfig == null || this.serverDemoFilterConfig.isIncluded(group, location, type);
    }

    protected boolean isExcluded(MetaInfGroup group, MetaInfDataLocation location, MetaInfDataType type) {
        return this.serverDemoFilterConfig != null && this.serverDemoFilterConfig.isExcluded(group, location, type);
    }
}

