/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.health.HealthCheck;
import javax.sql.DataSource;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseConnectionHealthGauge
extends HealthCheck
implements Gauge<Boolean> {
    private final DataSource dataSource;
    private final DatabasePlatform platform;

    public DatabaseConnectionHealthGauge(DataSource dataSource, DatabasePlatform platform) {
        this.dataSource = dataSource;
        this.platform = platform;
    }

    public Boolean getValue() {
        HealthCheck.Result result = this.execute();
        return result.isHealthy();
    }

    protected HealthCheck.Result check() throws Exception {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        template.execute(this.platform.getValidationQuery());
        return HealthCheck.Result.healthy();
    }
}

