/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.health.HealthCheck;

public class DatabaseConnectionPoolHealthCheck
extends HealthCheck {
    private final Gauge<Double> gauge;
    private final double unhealthyThreshold;

    public DatabaseConnectionPoolHealthCheck(Gauge<Double> gauge, double unhealthyThreshold) {
        this.gauge = gauge;
        this.unhealthyThreshold = unhealthyThreshold;
    }

    protected HealthCheck.Result check() throws Exception {
        Double value = (Double)this.gauge.getValue();
        if (value >= this.unhealthyThreshold) {
            return HealthCheck.Result.unhealthy((String)("Database connection pool usage ratio of " + value + " was greater than or equal to threshold of " + this.unhealthyThreshold));
        }
        return HealthCheck.Result.healthy();
    }
}

