/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import java.util.ArrayList;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.web.health.HealthMetric;
import org.kuali.rice.web.health.HealthStatus;

public class HealthStatusTest {
    private HealthStatus status;

    @Before
    public void setUp() {
        this.status = new HealthStatus();
    }

    @Test
    public void testEmptyConstructor() {
        Assert.assertEquals((Object)"Ok", (Object)this.status.getStatusCode());
        Assert.assertTrue((boolean)this.status.isOk());
        Assert.assertEquals((long)0L, (long)this.status.getMetrics().size());
        Assert.assertNull((Object)this.status.getMessage());
    }

    @Test
    public void testConstructor() {
        HealthStatus okStatus = new HealthStatus("Ok");
        Assert.assertEquals((Object)"Ok", (Object)okStatus.getStatusCode());
        Assert.assertTrue((boolean)okStatus.isOk());
        HealthStatus failedStatus = new HealthStatus("Failed");
        Assert.assertEquals((Object)"Failed", (Object)failedStatus.getStatusCode());
        Assert.assertFalse((boolean)failedStatus.isOk());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor_Invalid_Status() {
        new HealthStatus("blah!");
    }

    @Test
    public void testSetStatusCode() {
        Assert.assertTrue((boolean)this.status.isOk());
        this.status.setStatusCode("Failed");
        Assert.assertFalse((boolean)this.status.isOk());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetStatusCode_Invalid_Code() {
        Assert.assertTrue((boolean)this.status.isOk());
        this.status.setStatusCode("bad");
    }

    @Test
    public void testSetMessage() {
        Assert.assertNull((Object)this.status.getMessage());
        this.status.setMessage("my message");
        Assert.assertEquals((Object)"my message", (Object)this.status.getMessage());
        this.status.setMessage(null);
        Assert.assertNull((Object)this.status.getMessage());
    }

    @Test
    public void testSetMetrics() {
        ArrayList<HealthMetric> metrics = new ArrayList<HealthMetric>();
        metrics.add(new HealthMetric("a", "b", (Object)"c"));
        metrics.add(new HealthMetric("1", "2", (Object)"3"));
        this.status.setMetrics(metrics);
        Assert.assertEquals((long)2L, (long)this.status.getMetrics().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetMetrics_Null() {
        this.status.setMetrics(null);
    }

    @Test
    public void testAppendMessage() {
        this.status.appendMessage("a:b", "ab");
        Assert.assertEquals((Object)"* a:b -> ab", (Object)this.status.getMessage());
        this.status.appendMessage("1:2", "12");
        Assert.assertEquals((Object)"* a:b -> ab * 1:2 -> 12", (Object)this.status.getMessage());
    }

    @Test
    public void testJsonSerialization_Null_Message_Empty_Array() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)this.status);
        Assert.assertEquals((Object)"{\"Status\":\"Ok\",\"Metrics\":[]}", (Object)json);
        this.status.setStatusCode("Failed");
        json = mapper.writeValueAsString((Object)this.status);
        Assert.assertEquals((Object)"{\"Status\":\"Failed\",\"Metrics\":[]}", (Object)json);
        this.status.setMessage("");
        json = mapper.writeValueAsString((Object)this.status);
        Assert.assertEquals((Object)"{\"Status\":\"Failed\",\"Metrics\":[]}", (Object)json);
    }

    @Test
    public void testJsonSerialization() throws Exception {
        this.status.getMetrics().add(new HealthMetric("a", "b", (Object)"c"));
        this.status.getMetrics().add(new HealthMetric("1", "2", (Object)"3"));
        this.status.appendMessage("a:b", "something's broken");
        this.status.setStatusCode("Failed");
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)this.status);
        Assert.assertEquals((Object)"{\"Status\":\"Failed\",\"Message\":\"* a:b -> something's broken\",\"Metrics\":[{\"Measure\":\"a\",\"Metric\":\"b\",\"Value\":\"c\"},{\"Measure\":\"1\",\"Metric\":\"2\",\"Value\":\"3\"}]}", (Object)json);
    }
}

