/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import com.codahale.metrics.Gauge;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.web.health.DatabaseConnectionPoolMetricSet;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DatabaseConnectionPoolMetricSetTest {
    @Test
    public void testGetMetrics_XAPool() throws Exception {
        StandardXAPoolDataSource dataSource = (StandardXAPoolDataSource)Mockito.mock(StandardXAPoolDataSource.class);
        Mockito.when((Object)dataSource.getLockedObjectCount()).thenReturn((Object)10);
        Mockito.when((Object)dataSource.getMinSize()).thenReturn((Object)5);
        Mockito.when((Object)dataSource.getMaxSize()).thenReturn((Object)20);
        DatabaseConnectionPoolMetricSet metricSet = new DatabaseConnectionPoolMetricSet("xapool:", (DataSource)dataSource);
        Map metrics = metricSet.getMetrics();
        Assert.assertEquals((Object)10, (Object)((Gauge)metrics.get("xapool:pool.active")).getValue());
        Assert.assertEquals((Object)5, (Object)((Gauge)metrics.get("xapool:pool.min")).getValue());
        Assert.assertEquals((Object)20, (Object)((Gauge)metrics.get("xapool:pool.max")).getValue());
        Assert.assertEquals((Object)0.5, (Object)((Gauge)metrics.get("xapool:pool.usage")).getValue());
    }

    @Test
    public void testGetMetrics_Bitronix() throws Exception {
        PoolingDataSource dataSource = (PoolingDataSource)Mockito.mock(PoolingDataSource.class);
        Mockito.when((Object)dataSource.getTotalPoolSize()).thenReturn((Object)15L);
        Mockito.when((Object)dataSource.getInPoolSize()).thenReturn((Object)5L);
        Mockito.when((Object)dataSource.getMinPoolSize()).thenReturn((Object)5);
        Mockito.when((Object)dataSource.getMaxPoolSize()).thenReturn((Object)20);
        DatabaseConnectionPoolMetricSet metricSet = new DatabaseConnectionPoolMetricSet("btm:", (DataSource)dataSource);
        Map metrics = metricSet.getMetrics();
        Assert.assertEquals((Object)10, (Object)((Gauge)metrics.get("btm:pool.active")).getValue());
        Assert.assertEquals((Object)5, (Object)((Gauge)metrics.get("btm:pool.min")).getValue());
        Assert.assertEquals((Object)20, (Object)((Gauge)metrics.get("btm:pool.max")).getValue());
        Assert.assertEquals((Object)0.5, (Object)((Gauge)metrics.get("btm:pool.usage")).getValue());
    }

    @Test
    public void testGetMetrics_DBCP() throws Exception {
        BasicDataSource dataSource = (BasicDataSource)Mockito.mock(BasicDataSource.class);
        Mockito.when((Object)dataSource.getNumActive()).thenReturn((Object)10);
        Mockito.when((Object)dataSource.getMinIdle()).thenReturn((Object)5);
        Mockito.when((Object)dataSource.getMaxActive()).thenReturn((Object)20);
        DatabaseConnectionPoolMetricSet metricSet = new DatabaseConnectionPoolMetricSet("dbcp:", (DataSource)dataSource);
        Map metrics = metricSet.getMetrics();
        Assert.assertEquals((Object)10, (Object)((Gauge)metrics.get("dbcp:pool.active")).getValue());
        Assert.assertEquals((Object)5, (Object)((Gauge)metrics.get("dbcp:pool.min")).getValue());
        Assert.assertEquals((Object)20, (Object)((Gauge)metrics.get("dbcp:pool.max")).getValue());
        Assert.assertEquals((Object)0.5, (Object)((Gauge)metrics.get("dbcp:pool.usage")).getValue());
    }

    @Test
    public void testGetMetrics_Unknown() throws Exception {
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        DatabaseConnectionPoolMetricSet metricSet = new DatabaseConnectionPoolMetricSet("unknown:", dataSource);
        Assert.assertTrue((String)"Metrics map should be empty", (boolean)metricSet.getMetrics().isEmpty());
    }

    @Test
    public void testGetMetrics_Wrapped_XAPool() throws Exception {
        StandardXAPoolDataSource dataSource = (StandardXAPoolDataSource)Mockito.mock(StandardXAPoolDataSource.class);
        Mockito.when((Object)dataSource.getLockedObjectCount()).thenReturn((Object)10);
        Mockito.when((Object)dataSource.getMinSize()).thenReturn((Object)5);
        Mockito.when((Object)dataSource.getMaxSize()).thenReturn((Object)20);
        DataSource wrapperDataSource = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)wrapperDataSource.isWrapperFor(StandardXAPoolDataSource.class)).thenReturn((Object)true);
        Mockito.when((Object)wrapperDataSource.unwrap(StandardXAPoolDataSource.class)).thenReturn((Object)dataSource);
        DatabaseConnectionPoolMetricSet metricSet = new DatabaseConnectionPoolMetricSet("xapool:", wrapperDataSource);
        Map metrics = metricSet.getMetrics();
        Assert.assertEquals((Object)10, (Object)((Gauge)metrics.get("xapool:pool.active")).getValue());
        Assert.assertEquals((Object)5, (Object)((Gauge)metrics.get("xapool:pool.min")).getValue());
        Assert.assertEquals((Object)20, (Object)((Gauge)metrics.get("xapool:pool.max")).getValue());
        Assert.assertEquals((Object)0.5, (Object)((Gauge)metrics.get("xapool:pool.usage")).getValue());
    }

    @Test
    public void testGetMetrics_Wrapped_SQLException() throws Exception {
        StandardXAPoolDataSource dataSource = (StandardXAPoolDataSource)Mockito.mock(StandardXAPoolDataSource.class);
        DataSource wrapperDataSource = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)wrapperDataSource.isWrapperFor(StandardXAPoolDataSource.class)).thenThrow(new Throwable[]{new SQLException()});
        DatabaseConnectionPoolMetricSet metricSet = new DatabaseConnectionPoolMetricSet("xapool:", wrapperDataSource);
        Map metrics = metricSet.getMetrics();
        Assert.assertTrue((String)"Metrics map should be empty", (boolean)metricSet.getMetrics().isEmpty());
    }
}

