/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.ingest;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.xml.LocationXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlIngesterService;
import org.slf4j.Logger;

public final class IngestXmlExecutable
implements Executable {
    private static final Logger logger = LoggerUtils.make();
    private static final String XML_SUFFIX = ".xml";
    private final List<String> xmlDocumentLocations;
    private final boolean skip;
    private final Optional<XmlIngesterService> xmlIngesterService;

    public void execute() {
        if (this.skip) {
            logger.info("Skipping XML ingestion");
            return;
        }
        long start = System.currentTimeMillis();
        logger.info("Starting XML Ingester.");
        for (String xmlDocumentLocation : this.xmlDocumentLocations) {
            logger.info("Ingesting XML documents listed in [{}]", (Object)xmlDocumentLocation);
        }
        List<XmlDocCollection> xmlDocumentCollections = this.getXmlDocCollectionList(this.xmlDocumentLocations);
        logger.info("Found {} files to ingest.", (Object)xmlDocumentCollections.size());
        Collection<XmlDocCollection> failedXmlDocumentCollections = this.ingest(xmlDocumentCollections);
        this.validateNoFailures(failedXmlDocumentCollections);
        logger.info("There were zero failures ingesting {} XML documents", (Object)xmlDocumentCollections.size());
        long end = System.currentTimeMillis() - start;
        logger.info("Finished ingesting bootstrap XML - {}", (Object)FormatUtils.getTime((long)end));
    }

    private List<XmlDocCollection> getXmlDocCollectionList(List<String> locationListings) {
        ArrayList xmlDocCollectionList = Lists.newArrayList();
        List locations = LocationUtils.getLocations(locationListings);
        for (String location : locations) {
            Preconditions.checkState((boolean)StringUtils.endsWith((CharSequence)location.toLowerCase(), (CharSequence)XML_SUFFIX), (String)"[%s] is not an XML document", (Object[])new Object[]{location});
            Preconditions.checkState((boolean)LocationUtils.exists((String)location), (String)"[%s] does not exist", (Object[])new Object[]{location});
            logger.info("[{}]", (Object)location);
            xmlDocCollectionList.add(new LocationXmlDocCollection(location));
        }
        return xmlDocCollectionList;
    }

    private Collection<XmlDocCollection> ingest(List<XmlDocCollection> collections) {
        try {
            return this.getXmlIngesterService().ingest(collections);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error ingesting XML documents", e);
        }
    }

    private void validateNoFailures(Collection<XmlDocCollection> failedXmlDocumentCollections) {
        if (failedXmlDocumentCollections.isEmpty()) {
            return;
        }
        ArrayList failureNamesList = Lists.newArrayList();
        for (XmlDocCollection failedXmlDocumentCollection : failedXmlDocumentCollections) {
            failureNamesList.add(failedXmlDocumentCollection.getFile().getName());
        }
        String failureNames = StringUtils.join((Iterable)failureNamesList, (String)", ");
        Preconditions.checkState((boolean)false, (String)"%s XML documents failed to ingest -> [%s]", (Object[])new Object[]{failedXmlDocumentCollections.size(), failureNames});
    }

    public XmlIngesterService getXmlIngesterService() {
        return this.xmlIngesterService.isPresent() ? (XmlIngesterService)this.xmlIngesterService.get() : CoreApiServiceLocator.getXmlIngesterService();
    }

    private IngestXmlExecutable(Builder builder) {
        this.xmlDocumentLocations = builder.xmlDocumentLocations;
        this.skip = builder.skip;
        this.xmlIngesterService = builder.xmlIngesterService;
    }

    public static Builder builder(List<String> xmlDocumentLocations) {
        return new Builder(xmlDocumentLocations);
    }

    public static class Builder {
        private final List<String> xmlDocumentLocations;
        private Optional<XmlIngesterService> xmlIngesterService = Optional.absent();
        private boolean skip;

        public Builder(String xmlDocumentLocation) {
            this.xmlDocumentLocations = Collections.singletonList(xmlDocumentLocation);
        }

        public Builder(List<String> xmlDocumentLocations) {
            this.xmlDocumentLocations = xmlDocumentLocations;
        }

        public Builder service(XmlIngesterService service) {
            this.xmlIngesterService = Optional.of((Object)service);
            return this;
        }

        public Builder skip(boolean skip) {
            this.skip = skip;
            return this;
        }

        public IngestXmlExecutable build() {
            IngestXmlExecutable instance = new IngestXmlExecutable(this);
            Builder.validate(instance);
            return instance;
        }

        private static void validate(IngestXmlExecutable instance) {
            Preconditions.checkNotNull((Object)instance.xmlIngesterService, (Object)"service cannot be null");
            Preconditions.checkArgument((!CollectionUtils.isEmpty((Collection)instance.xmlDocumentLocations) ? 1 : 0) != 0, (Object)"locationListings cannot be empty");
            for (String locationListing : instance.xmlDocumentLocations) {
                Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)locationListing) ? 1 : 0) != 0, (Object)"locationListings cannot have blank entries");
                Preconditions.checkArgument((boolean)LocationUtils.exists((String)locationListing), (String)"[%s] does not exist", (Object[])new Object[]{locationListing});
            }
        }
    }
}

