/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.ingest;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Properties;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.Str;
import org.kuali.common.util.log.LoggerUtils;
import org.kuali.common.util.property.ImmutableProperties;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.impl.config.property.ConfigLogger;
import org.kuali.rice.core.impl.config.property.JAXBConfigImpl;
import org.kuali.rice.core.web.util.PropertySources;
import org.slf4j.Logger;

public class RiceConfigUtils {
    private static final Logger logger = LoggerUtils.make();

    private RiceConfigUtils() {
    }

    public static Config getRootConfig(Properties loaded, String location, ServletContext servletContext) {
        Config config = ConfigContext.getCurrentContextConfig();
        Preconditions.checkNotNull((Object)config, (Object)"'config' cannot be null");
        Properties listenerProperties = RiceConfigUtils.getProperties(config);
        JAXBConfigImpl parsed = RiceConfigUtils.parseConfig(location, listenerProperties);
        RiceConfigUtils.addAndOverride(loaded, parsed.getRawProperties());
        Properties servlet = PropertySources.convert((ServletContext)servletContext);
        Properties global = PropertyUtils.getGlobalProperties((Properties)servlet);
        RiceConfigUtils.addAndOverride(loaded, global);
        logger.info("Using {} distinct properties", (Object)loaded.size());
        return new JAXBConfigImpl(loaded);
    }

    public static JAXBConfigImpl parseConfig(String location) {
        return RiceConfigUtils.parseConfig(location, ImmutableProperties.of());
    }

    public static JAXBConfigImpl parseConfig(String location, Properties properties) {
        try {
            JAXBConfigImpl config = new JAXBConfigImpl(location, properties);
            config.parseConfig();
            return config;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error parsing config", e);
        }
    }

    public static JAXBConfigImpl parseAndInit(String location) {
        JAXBConfigImpl config = RiceConfigUtils.parseConfig(location);
        ConfigContext.init((Config)config);
        return config;
    }

    public static Properties getProperties(Config config) {
        if (config instanceof JAXBConfigImpl) {
            JAXBConfigImpl jci = (JAXBConfigImpl)config;
            return jci.getRawProperties();
        }
        logger.warn("Unable to access raw Rice config properties.");
        return config.getProperties();
    }

    public static void putProperties(Config config, Properties properties) {
        TreeSet keys = Sets.newTreeSet(properties.stringPropertyNames());
        for (String key : keys) {
            config.putProperty(key, properties.getProperty(key));
        }
    }

    private static void add(Properties oldProperties, Properties newProperties) {
        TreeSet newKeys = Sets.newTreeSet((Iterable)Sets.difference(newProperties.stringPropertyNames(), oldProperties.stringPropertyNames()));
        if (newKeys.isEmpty()) {
            return;
        }
        logger.info("Adding {} properties", (Object)newKeys.size());
        for (String newKey : newKeys) {
            String value = newProperties.getProperty(newKey);
            logger.debug("Adding - [{}]=[{}]", (Object)newKey, (Object)RiceConfigUtils.toLogMsg(newKey, value));
            oldProperties.setProperty(newKey, value);
        }
    }

    private static void override(Properties oldProperties, Properties newProperties) {
        TreeSet commonKeys = Sets.newTreeSet((Iterable)Sets.intersection(newProperties.stringPropertyNames(), oldProperties.stringPropertyNames()));
        if (commonKeys.isEmpty()) {
            return;
        }
        logger.debug("{} keys in common", (Object)commonKeys.size());
        for (String commonKey : commonKeys) {
            String oldValue = oldProperties.getProperty(commonKey);
            String newValue = newProperties.getProperty(commonKey);
            if (newValue.equals(oldValue)) continue;
            Object[] args = new Object[]{commonKey, RiceConfigUtils.toLogMsg(commonKey, oldValue), RiceConfigUtils.toLogMsg(commonKey, newValue)};
            logger.info("Overriding - [{}]=[{}]->[{}]", args);
            oldProperties.setProperty(commonKey, newValue);
        }
    }

    private static void addAndOverride(Properties oldProperties, Properties newProperties) {
        RiceConfigUtils.add(oldProperties, newProperties);
        RiceConfigUtils.override(oldProperties, newProperties);
    }

    private static String toLogMsg(String key, String value) {
        return Str.flatten((String)ConfigLogger.getDisplaySafeValue((String)key, (String)value));
    }
}

