/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.attributes;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.module.apikit.HeaderName;
import org.mule.module.apikit.api.exception.InvalidHeaderException;
import org.mule.module.apikit.exception.NotAcceptableException;
import org.mule.module.apikit.helpers.AttributesHelper;
import org.mule.module.apikit.validation.attributes.MimeTypeParser;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.IResponse;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersValidator {
    private static final Logger logger = LoggerFactory.getLogger(HeadersValidator.class);
    private MultiMap<String, String> headers;

    public void validateAndAddDefaults(MultiMap<String, String> incomingHeaders, IAction action, boolean headersStrictValidation) throws InvalidHeaderException, NotAcceptableException {
        this.headers = incomingHeaders;
        this.analyseRequestHeaders(action, headersStrictValidation);
        this.analyseAcceptHeader(incomingHeaders, action);
    }

    private void analyseRequestHeaders(IAction action, boolean headersStrictValidation) throws InvalidHeaderException {
        if (headersStrictValidation) {
            this.validateHeadersStrictly(action);
        }
        for (Map.Entry entry : action.getHeaders().entrySet()) {
            String ramlHeader = (String)entry.getKey();
            IParameter ramlType = (IParameter)entry.getValue();
            if (ramlHeader.contains("{?}")) {
                String regex = ramlHeader.replace("{?}", ".*");
                for (String incomingHeader : this.headers.keySet()) {
                    if (!incomingHeader.matches(regex)) continue;
                    this.validateHeader(this.headers.getAll((Object)incomingHeader), ramlHeader, ramlType);
                }
                continue;
            }
            List<String> values = AttributesHelper.getParamsIgnoreCase(this.headers, ramlHeader);
            if (values.isEmpty() && ramlType.isRequired()) {
                throw new InvalidHeaderException("Required header " + ramlHeader + " not specified");
            }
            if (values.isEmpty() && ramlType.getDefaultValue() != null) {
                this.headers = AttributesHelper.addParam(this.headers, ramlHeader, ramlType.getDefaultValue());
            }
            this.validateHeader(values, ramlHeader, ramlType);
        }
    }

    private void validateHeadersStrictly(IAction action) throws InvalidHeaderException {
        Set standardHeaders;
        Set ramlHeaders = action.getHeaders().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        Set templateHeaders = ramlHeaders.stream().filter(header -> header.contains("{?}")).map(header -> header.replace("{?}", ".*")).collect(Collectors.toSet());
        Set unmatchedHeaders = this.headers.keySet().stream().filter(header -> templateHeaders.stream().noneMatch(header::matches)).collect(Collectors.toSet());
        Sets.SetView undefinedHeaders = Sets.difference(unmatchedHeaders, (Set)Sets.union(ramlHeaders, standardHeaders = Arrays.stream(HeaderName.values()).map(header -> header.getName().toLowerCase()).collect(Collectors.toSet())));
        if (!undefinedHeaders.isEmpty()) {
            throw new InvalidHeaderException(Joiner.on((String)", ").join((Iterable)undefinedHeaders) + " headers are not defined in RAML and strict headers validation property is true.");
        }
    }

    private void validateHeader(List<String> values, String name, IParameter type) throws InvalidHeaderException {
        if (values.isEmpty()) {
            return;
        }
        if (values.size() > 1 && !type.isArray() && !type.isRepeat()) {
            throw new InvalidHeaderException("Header " + name + " is not repeatable");
        }
        if (type.isArray()) {
            this.validateType(name, values, type);
        } else {
            this.validateType(name, values.get(0), type);
        }
    }

    private void validateType(String name, List<String> values, IParameter type) throws InvalidHeaderException {
        StringBuilder yamlValue = new StringBuilder();
        for (String value : values) {
            yamlValue.append("- ").append(value).append("\n");
        }
        this.validateType(name, yamlValue.toString(), type);
    }

    private void validateType(String name, String value, IParameter type) throws InvalidHeaderException {
        if (!type.validate(value)) {
            throw new InvalidHeaderException(String.format("Invalid value '%s' for header %s. %s", value, name, type.message(value)));
        }
    }

    private void analyseAcceptHeader(MultiMap<String, String> incomingHeaders, IAction action) throws NotAcceptableException {
        List<String> mimeTypes = this.getResponseMimeTypes(action);
        if (action == null || action.getResponses() == null || mimeTypes.isEmpty()) {
            return;
        }
        MediaType bestMatch = MimeTypeParser.bestMatch(mimeTypes, AttributesHelper.getAcceptedResponseMediaTypes(incomingHeaders));
        if (bestMatch == null) {
            throw new NotAcceptableException();
        }
        logger.debug("=== negotiated response content-type: " + bestMatch.toString());
        for (String representation : mimeTypes) {
            if (!representation.equals(bestMatch.withoutParameters().toString())) continue;
            return;
        }
        throw new NotAcceptableException();
    }

    private List<String> getResponseMimeTypes(IAction action) {
        IResponse response;
        ArrayList<String> mimeTypes = new ArrayList<String>();
        int status = this.getSuccessStatus(action);
        if (status != -1 && (response = (IResponse)action.getResponses().get(String.valueOf(status))) != null && response.hasBody()) {
            Map interfacesOfTypes = response.getBody();
            for (Map.Entry entry : interfacesOfTypes.entrySet()) {
                mimeTypes.add(((IMimeType)entry.getValue()).getType());
            }
            logger.debug(String.format("=== adding response mimeTypes for status %d : %s", status, mimeTypes));
        }
        return mimeTypes;
    }

    protected int getSuccessStatus(IAction action) {
        for (String status : action.getResponses().keySet()) {
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return code;
        }
        return 200;
    }

    public MultiMap<String, String> getNewHeaders() {
        return this.headers;
    }
}

