/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.body.schema.v2;

import java.util.List;
import org.mule.module.apikit.api.exception.BadRequestException;
import org.mule.module.apikit.validation.body.schema.IRestSchemaValidatorStrategy;
import org.mule.raml.implv2.v10.model.MimeTypeImpl;
import org.mule.raml.interfaces.model.IMimeType;
import org.raml.v2.api.model.common.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSchemaV2Validator
implements IRestSchemaValidatorStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(RestSchemaV2Validator.class);
    private IMimeType mimeType;

    public RestSchemaV2Validator(IMimeType mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public void validate(String payload) throws BadRequestException {
        if (!(this.mimeType instanceof MimeTypeImpl)) {
            throw new RuntimeException("not supported");
        }
        List validationResults = ((MimeTypeImpl)this.mimeType).validate(payload);
        if (!validationResults.isEmpty()) {
            String logMessage = ((ValidationResult)validationResults.get(0)).getMessage();
            logger.info("Schema validation failed: " + logMessage);
            throw new BadRequestException(logMessage);
        }
    }
}

