/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api;

import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.mule.extension.file.common.api.util.UriUtils;

public enum PredicateType {
    EXTERNAL_FILE_SYSTEM{

        @Override
        public Predicate<String> getPredicate(String pattern, boolean caseSensitive) {
            String regex = UriUtils.toRegexPattern(PredicateType.getPattern(pattern));
            return Pattern.compile(regex, caseSensitive ? 0 : 2).asPredicate();
        }
    }
    ,
    LOCAL_FILE_SYSTEM{

        @Override
        public Predicate<String> getPredicate(String pattern, boolean caseSensitive) {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher(pattern);
            return path -> matcher.matches(Paths.get(path, new String[0]));
        }
    };


    public abstract Predicate<String> getPredicate(String var1, boolean var2);

    private static String getPattern(String syntaxAndInput) {
        int pos = syntaxAndInput.indexOf(58);
        return syntaxAndInput.substring(pos + 1);
    }
}

