/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class NoStaticImport
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.Collections emptyList()")
    private final String methodPattern;

    public String getDisplayName() {
        return "Remove static import";
    }

    public String getDescription() {
        return "Removes static imports and replaces them with qualified references. For example, `emptyList()` becomes `Collections.emptyList()`.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(this.methodPattern);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m;
                MethodMatcher methodMatcher = new MethodMatcher(NoStaticImport.this.methodPattern);
                if (methodMatcher.matches((J.MethodInvocation)(m = super.visitMethodInvocation(method, ctx))) && ((J.MethodInvocation)m).getSelect() == null && ((J.MethodInvocation)m).getMethodType() != null) {
                    JavaType.FullyQualified receiverType = ((J.MethodInvocation)m).getMethodType().getDeclaringType();
                    RemoveImport op = new RemoveImport(receiverType.getFullyQualifiedName() + "." + method.getSimpleName(), true);
                    if (!this.getAfterVisit().contains((Object)op)) {
                        this.doAfterVisit(op);
                    }
                    this.maybeAddImport(receiverType.getFullyQualifiedName());
                    m = ((J.MethodInvocation)m).withSelect(new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, receiverType.getClassName(), receiverType, null));
                }
                return m;
            }
        };
    }

    @NonNull
    public String toString() {
        return "NoStaticImport(methodPattern=" + this.getMethodPattern() + ")";
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public NoStaticImport(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoStaticImport)) {
            return false;
        }
        NoStaticImport other = (NoStaticImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof NoStaticImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

