/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.EqualsAvoidsNullVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EqualsAvoidsNullStyle;
import org.openrewrite.java.tree.JavaSourceFile;

public class EqualsAvoidsNull
extends Recipe {
    public String getDisplayName() {
        return "Equals avoids null";
    }

    public String getDescription() {
        return "Checks that any combination of String literals is on the left side of an `equals()` comparison. Also checks for String literals assigned to some field (such as `someString.equals(anotherString = \"text\"))`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1132");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new EqualsAvoidsNullFromCompilationUnitStyle();
    }

    private static class EqualsAvoidsNullFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private EqualsAvoidsNullFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            EqualsAvoidsNullStyle style = (EqualsAvoidsNullStyle)((SourceFile)cu).getStyle(EqualsAvoidsNullStyle.class);
            if (style == null) {
                style = Checkstyle.equalsAvoidsNull();
            }
            this.doAfterVisit(new EqualsAvoidsNullVisitor(style));
            return cu;
        }
    }
}

