/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.Collection;
import org.openrewrite.Incubating;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeMethodAccessLevelVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.style.HideUtilityClassConstructorStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.0.0")
public class HideUtilityClassConstructorVisitor<P>
extends JavaIsoVisitor<P> {
    private final UtilityClassMatcher utilityClassMatcher;

    public HideUtilityClassConstructorVisitor(HideUtilityClassConstructorStyle style) {
        this.utilityClassMatcher = new UtilityClassMatcher(style.getIgnoreIfAnnotatedBy());
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        if (((J.ClassDeclaration)c).getKind() != J.ClassDeclaration.Kind.Type.Interface && !((J.ClassDeclaration)c).hasModifier(J.Modifier.Type.Abstract) && this.utilityClassMatcher.isRefactorableUtilityClass((J.ClassDeclaration)c)) {
            c = (J.ClassDeclaration)new UtilityClassWithImplicitDefaultConstructorVisitor().visit(c, p, this.getCursor());
            c = (J.ClassDeclaration)new UtilityClassWithExposedConstructorInspectionVisitor().visit(c, p, this.getCursor());
        }
        return c;
    }

    private static final class UtilityClassMatcher {
        private final Collection<AnnotationMatcher> ignorableAnnotations;

        private UtilityClassMatcher(Collection<String> ignorableAnnotations) {
            this.ignorableAnnotations = new ArrayList<AnnotationMatcher>(ignorableAnnotations.size());
            for (String ignorableAnnotation : ignorableAnnotations) {
                this.ignorableAnnotations.add(new AnnotationMatcher(ignorableAnnotation));
            }
        }

        boolean hasIgnorableAnnotation(J.ClassDeclaration c) {
            for (J.Annotation classAnn : c.getAllAnnotations()) {
                for (AnnotationMatcher ignorableAnn : this.ignorableAnnotations) {
                    if (!ignorableAnn.matches(classAnn)) continue;
                    return true;
                }
            }
            return false;
        }

        static boolean hasMainMethod(J.ClassDeclaration c) {
            if (c.getType() == null) {
                return false;
            }
            for (Statement statement : c.getBody().getStatements()) {
                J.MethodDeclaration md;
                if (!(statement instanceof J.MethodDeclaration) || (md = (J.MethodDeclaration)statement).isConstructor() || !md.hasModifier(J.Modifier.Type.Public) || !md.hasModifier(J.Modifier.Type.Static) || md.getReturnTypeExpression() == null || !JavaType.Primitive.Void.equals(md.getReturnTypeExpression().getType()) || !new MethodMatcher(c.getType().getFullyQualifiedName() + " main(String)").matches(md, c)) continue;
                return true;
            }
            return false;
        }

        static boolean hasImplicitDefaultConstructor(J.ClassDeclaration c) {
            for (Statement statement : c.getBody().getStatements()) {
                J.MethodDeclaration methodDeclaration;
                if (!(statement instanceof J.MethodDeclaration) || !(methodDeclaration = (J.MethodDeclaration)statement).isConstructor()) continue;
                return false;
            }
            return true;
        }

        boolean isRefactorableUtilityClass(J.ClassDeclaration c) {
            return UtilityClassMatcher.isUtilityClass(c) && !this.hasIgnorableAnnotation(c) && !UtilityClassMatcher.hasMainMethod(c);
        }

        static boolean isUtilityClass(J.ClassDeclaration c) {
            if (c.getImplements() != null || c.getExtends() != null) {
                return false;
            }
            int staticMethodCount = UtilityClassMatcher.countStaticMethods(c);
            if (staticMethodCount < 0) {
                return false;
            }
            int staticFieldCount = UtilityClassMatcher.countStaticFields(c);
            if (staticFieldCount < 0) {
                return false;
            }
            return staticMethodCount != 0 || staticFieldCount != 0;
        }

        private static int countStaticFields(J.ClassDeclaration classDeclaration) {
            int count = 0;
            for (Statement statement : classDeclaration.getBody().getStatements()) {
                if (!(statement instanceof J.VariableDeclarations)) continue;
                J.VariableDeclarations field = (J.VariableDeclarations)statement;
                if (!field.hasModifier(J.Modifier.Type.Static)) {
                    return -1;
                }
                if (field.hasModifier(J.Modifier.Type.Private)) continue;
                ++count;
            }
            return count;
        }

        private static int countStaticMethods(J.ClassDeclaration classDeclaration) {
            int count = 0;
            for (Statement statement : classDeclaration.getBody().getStatements()) {
                J.MethodDeclaration method;
                if (!(statement instanceof J.MethodDeclaration) || (method = (J.MethodDeclaration)statement).isConstructor()) continue;
                if (!method.hasModifier(J.Modifier.Type.Static)) {
                    return -1;
                }
                if (method.hasModifier(J.Modifier.Type.Private)) continue;
                ++count;
            }
            return count;
        }
    }

    private static class UtilityClassWithExposedConstructorInspectionVisitor<P>
    extends JavaIsoVisitor<P> {
        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
            J md = super.visitMethodDeclaration(method, (Object)p);
            if (((J.MethodDeclaration)md).getMethodType() == null || !((J.MethodDeclaration)md).isConstructor() || ((J.MethodDeclaration)md).hasModifier(J.Modifier.Type.Private) || ((J.MethodDeclaration)md).hasModifier(J.Modifier.Type.Protected) || ((J.MethodDeclaration)md).getMethodType().getDeclaringType().getKind().equals((Object)JavaType.FullyQualified.Kind.Enum)) {
                return md;
            }
            ChangeMethodAccessLevelVisitor changeMethodAccessLevelVisitor = new ChangeMethodAccessLevelVisitor(new MethodMatcher(method), J.Modifier.Type.Private);
            md = (J.MethodDeclaration)changeMethodAccessLevelVisitor.visit(md, p, this.getCursor());
            assert (md != null);
            return md;
        }
    }

    private static class UtilityClassWithImplicitDefaultConstructorVisitor<P>
    extends JavaIsoVisitor<P> {
        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
            J c = super.visitClassDeclaration(classDecl, (Object)p);
            if (UtilityClassMatcher.hasImplicitDefaultConstructor((J.ClassDeclaration)c) && !J.ClassDeclaration.Kind.Type.Enum.equals((Object)classDecl.getKind())) {
                c = (J.ClassDeclaration)c.withTemplate(JavaTemplate.builder(() -> ((UtilityClassWithImplicitDefaultConstructorVisitor)this).getCursor(), "private #{}() {}").build(), ((J.ClassDeclaration)c).getBody().getCoordinates().lastStatement(), classDecl.getSimpleName());
            }
            return c;
        }
    }
}

