/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

@Incubating(since="7.10.0")
public class IndexOfShouldNotCompareGreaterThanZero
extends Recipe {
    private static final MethodMatcher STRING_INDEX_MATCHER = new MethodMatcher("java.lang.String indexOf(String)");
    private static final MethodMatcher LIST_INDEX_MATCHER = new MethodMatcher("java.util.List indexOf(Object)");

    public String getDisplayName() {
        return "`indexOf` should not compare greater than zero";
    }

    public String getDescription() {
        return "Replaces `String#indexOf(String) > 0` and `List#indexOf(Object) > 0` with `>=1`. Checking `indexOf` against `>0` ignores the first element, whereas `>-1` is inclusive of the first element. For clarity, `>=1` is used, because `>0` and `>=1` are semantically equal. Using `>0` may appear to be a mistake with the intent of including all elements. If the intent is to check whether a value in included in a `String` or `List`, the `String#contains(String)` or `List#contains(Object)` methods may be better options altogether.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2692");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new IndexOfShouldNotCompareGreaterThanZeroVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesMethod(STRING_INDEX_MATCHER));
                this.doAfterVisit(new UsesMethod(LIST_INDEX_MATCHER));
                return cu;
            }
        };
    }

    private static class IndexOfShouldNotCompareGreaterThanZeroVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private IndexOfShouldNotCompareGreaterThanZeroVisitor() {
        }

        @Override
        public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
            J b = super.visitBinary(binary, ctx);
            if (((J.Binary)b).getOperator() == J.Binary.Type.GreaterThan && ((J.Binary)b).getLeft() instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)((J.Binary)b).getLeft();
                if ((STRING_INDEX_MATCHER.matches(mi) || LIST_INDEX_MATCHER.matches(mi)) && ((J.Binary)b).getRight() instanceof J.Literal && "0".equals(((J.Literal)((J.Binary)b).getRight()).getValueSource())) {
                    b = ((J.Binary)b).withRight(((J.Literal)((J.Binary)b).getRight()).withValueSource("1")).withOperator(J.Binary.Type.GreaterThanOrEqual);
                }
            }
            return b;
        }
    }
}

