/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.24.0")
public class RemoveRedundantTypeCast
extends Recipe {
    public String getDisplayName() {
        return "Remove redundant casts";
    }

    public String getDescription() {
        return "Removes unnecessary type casts. Does not currently check casts in lambdas, class constructors, and method invocations.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1905");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitTypeCast(J.TypeCast typeCast, ExecutionContext executionContext) {
                Cursor parent = this.getCursor().dropParentUntil(is -> is instanceof J.NewClass || is instanceof J.Lambda || is instanceof J.MethodInvocation || is instanceof J.ClassDeclaration);
                if (parent.getValue() instanceof J.NewClass || parent.getValue() instanceof J.Lambda || parent.getValue() instanceof J.MethodInvocation) {
                    return typeCast;
                }
                JavaType cast = typeCast.getType();
                if (cast instanceof JavaType.GenericTypeVariable) {
                    return typeCast;
                }
                JavaType expressionType = typeCast.getExpression().getType();
                if (typeCast.getClazz().getTree() instanceof J.ArrayType) {
                    while (expressionType instanceof JavaType.Array) {
                        expressionType = ((JavaType.Array)expressionType).getElemType();
                    }
                }
                if (cast != null && expressionType != null && (TypeUtils.isOfType(cast, expressionType) || TypeUtils.isAssignableTo(cast, expressionType))) {
                    return typeCast.getExpression();
                }
                return super.visitTypeCast(typeCast, executionContext);
            }
        };
    }
}

